/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.projects.persistence;

import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.DeploymentKeyImpl;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityWithOid;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.utils.BambooInterners;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="DEPLOYMENT_PROJECT", indexes={@Index(columnList="PLAN_KEY", name="deployment_plan_key"), @Index(columnList="NAME", name="deployment_plan_name")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="DEPLOYMENT_PROJECT_ID"))
public class MutableDeploymentProjectImpl
extends HibernateBambooEntityWithOid
implements MutableDeploymentProject {
    @Transient
    private DeploymentKey key;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="PLAN_KEY")
    @Type(type="com.atlassian.bamboo.plan.PlanKeyUserType")
    private PlanKey planKey;
    @JoinColumn(name="VCS_SPECS_SOURCE_ID")
    @Fetch(value=FetchMode.JOIN)
    @ManyToOne
    private VcsBambooSpecsSourceImpl vcsBambooSpecsSource;

    @NotNull
    public DeploymentKey getKey() {
        return this.key != null ? this.key : new DeploymentKeyImpl(Long.toString(this.getId()));
    }

    public void setKey(@NotNull DeploymentKey key) {
        this.key = key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = BambooInterners.intern((String)name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = BambooInterners.intern((String)description);
    }

    @Nullable
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    public void setPlanKey(PlanKey planKey) {
        this.planKey = planKey;
    }

    @Nullable
    public VcsBambooSpecsSource getVcsBambooSpecsSource() {
        return this.vcsBambooSpecsSource;
    }

    public void setVcsBambooSpecsSource(VcsBambooSpecsSource vcsBambooSpecsSource) {
        this.vcsBambooSpecsSource = (VcsBambooSpecsSourceImpl)vcsBambooSpecsSource;
    }
}

