/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.docker;

import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BambooDockerHelper {
    private static final Logger log = Logger.getLogger(BambooDockerHelper.class);
    public static final String DOCKER_EXECUTABLE_CAPABILITY = "system.docker.executable";
    public static final String DEFAULT_RSS_DOCKER_IMAGE = (String)BambooConstantUtils.preventInlining((Object)("atlassian/bamboo-specs-runner:" + BambooSpecVersion.getModelVersion()));

    public static boolean isDockerExecutableConfigured(CapabilitySetManager capabilitySetManager) {
        return BambooDockerHelper.getDockerExecutablePath(capabilitySetManager).isPresent();
    }

    public static Optional<Path> getDockerExecutablePath(CapabilitySetManager capabilitySetManager) {
        CapabilitySet sharedLocalCapabilitySet = capabilitySetManager.getSharedLocalCapabilitySet();
        if (sharedLocalCapabilitySet != null) {
            Capability dockerExecutableCapability = sharedLocalCapabilitySet.getCapability(DOCKER_EXECUTABLE_CAPABILITY);
            if (dockerExecutableCapability != null) {
                String dockerExecutablePath = dockerExecutableCapability.getValue();
                if (StringUtils.isNotEmpty((CharSequence)dockerExecutablePath)) {
                    return Optional.of(Paths.get(dockerExecutablePath, new String[0]));
                }
                log.debug((Object)"Docker capability is empty");
            } else {
                log.debug((Object)String.format("Docker capability %s not defined", DOCKER_EXECUTABLE_CAPABILITY));
            }
        }
        return Optional.empty();
    }
}

