/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.docker;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.docker.DockerContainerService;
import com.atlassian.bamboo.docker.DockerException;
import com.atlassian.bamboo.docker.PortMapping;
import com.atlassian.bamboo.docker.ProcessCommand;
import com.atlassian.bamboo.docker.RunConfig;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.util.BambooIOUtils;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerContainerServiceImpl
implements DockerContainerService {
    private static final Logger log = Logger.getLogger(DockerContainerServiceImpl.class);
    public static final String EQ_ARG = "%s=%s";
    @Inject
    private ProcessService processService;

    public void run(@NotNull ProcessContext processContext, @NotNull Path dockerPath, @NotNull String imageName, @NotNull RunConfig runConfig, @NotNull Path workingDirectory, @NotNull Map<String, String> environment) throws DockerException {
        block24: {
            Preconditions.checkState((processContext != null ? 1 : 0) != 0, (Object)"Process context must not be null");
            Preconditions.checkState((dockerPath != null ? 1 : 0) != 0, (Object)"Docker path must not be null");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)imageName), (Object)"Image name undefined");
            Preconditions.checkState((runConfig != null ? 1 : 0) != 0, (Object)"Run configuration must not be null");
            Preconditions.checkState((workingDirectory != null ? 1 : 0) != 0, (Object)"Working directory undefined");
            ProcessCommand.Builder commandBuilder = ProcessCommand.builder().add(dockerPath.toAbsolutePath().toString(), "run");
            for (DataVolume dataVolume : DockerContainerServiceImpl.remapHomeDirectories(runConfig.getVolumes())) {
                commandBuilder.add("--volume", Joiner.on((char)':').skipNulls().join((Object)dataVolume.getHostDirectory(), (Object)dataVolume.getContainerDirectory(), new Object[0]));
            }
            if (runConfig.getWorkDir().isPresent()) {
                commandBuilder.add("--workdir", (String)runConfig.getWorkDir().get());
            }
            for (Map.Entry entry : runConfig.getLinks().entrySet()) {
                commandBuilder.add("--link", Joiner.on((char)':').join(entry.getKey(), entry.getValue(), new Object[0]));
            }
            if (runConfig.isDetach()) {
                commandBuilder.add("--detach");
            } else {
                commandBuilder.add("--rm");
            }
            Optional containerName = runConfig.getContainerName();
            containerName.ifPresent(s -> commandBuilder.add("--name", (String)s));
            for (PortMapping ports : runConfig.getPorts()) {
                commandBuilder.add("-p", Joiner.on((char)':').skipNulls().join((Object)ports.getHostPort(), (Object)ports.getContainerPort(), new Object[0]));
            }
            for (Map.Entry env : runConfig.getEnv().entrySet()) {
                commandBuilder.add("-e", String.format(EQ_ARG, env.getKey(), env.getValue()));
            }
            for (String passedEnvVar : runConfig.getPassedEnv()) {
                commandBuilder.add("-e", passedEnvVar);
            }
            if (runConfig.getAdditionalArgs().isPresent()) {
                commandBuilder.addAll(CommandlineStringUtils.tokeniseCommandline((String)((String)runConfig.getAdditionalArgs().get())));
            }
            commandBuilder.add(imageName);
            if (runConfig.getCommand().isPresent()) {
                commandBuilder.addAll(CommandlineStringUtils.tokeniseCommandline((String)((String)runConfig.getCommand().get())));
            }
            try {
                this.execute(processContext, commandBuilder.build(), workingDirectory, environment);
                if (!containerName.isPresent() || !runConfig.isUseInitialisingScript()) break block24;
                String string = "initialiseDockerContainer.sh";
                try (BambooFiles.QuietlyRemoved temporaryFile = BambooFiles.quietlyRemoved((Path)DockerContainerServiceImpl.createTemporaryFile("initialiseDockerContainer.sh"));){
                    ProcessCommand copyInitScriptToContainer = this.copyInitScriptToContainer(temporaryFile.getPath(), dockerPath, (String)containerName.get(), "initialiseDockerContainer.sh");
                    this.execute(processContext, copyInitScriptToContainer, workingDirectory, environment);
                }
                ProcessCommand chownInitCommand = this.chownInitScriptInContainer(dockerPath, (String)containerName.get());
                this.execute(processContext, chownInitCommand, workingDirectory, environment, true);
                ProcessCommand chmodInitCommand = this.chmodInitScriptInContainer(dockerPath, (String)containerName.get());
                this.execute(processContext, chmodInitCommand, workingDirectory, environment, true);
                ProcessCommand runInitCommand = this.runInitScriptInContainer(dockerPath, (String)containerName.get());
                this.execute(processContext, runInitCommand, workingDirectory, environment);
            }
            catch (ProcessException processException) {
                throw new DockerException("Error running Docker run command", (Throwable)processException);
            }
        }
    }

    private ProcessCommand copyInitScriptToContainer(Path temporaryFile, Path dockerPath, String containerId, String scriptName) {
        try {
            BambooIOUtils.copy((InputStream)this.getClass().getResourceAsStream(scriptName), (OutputStream)Files.newOutputStream(temporaryFile, new OpenOption[0]));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ProcessCommand.Builder commandBuilder = ProcessCommand.builder().add(dockerPath.toAbsolutePath().toString(), "cp", temporaryFile.toString(), containerId + ":" + "/tmp" + "/initialiseContainer.sh");
        return commandBuilder.build();
    }

    private ProcessCommand chownInitScriptInContainer(Path dockerPath, String containerId) {
        return this.runInContainer(dockerPath, containerId, true, "chown", "root:root", "/tmp/initialiseContainer.sh");
    }

    private ProcessCommand chmodInitScriptInContainer(Path dockerPath, String containerId) {
        return this.runInContainer(dockerPath, containerId, true, "chmod", "755", "/tmp/initialiseContainer.sh");
    }

    private ProcessCommand runInitScriptInContainer(Path dockerPath, String containerId) {
        return this.runInContainer(dockerPath, containerId, false, "/tmp/initialiseContainer.sh");
    }

    private ProcessCommand runInContainer(Path dockerPath, String containerId, boolean asRoot, String ... args) {
        ProcessCommand.Builder commandBuilder = ProcessCommand.builder().add(dockerPath.toAbsolutePath().toString(), "exec");
        if (asRoot) {
            commandBuilder.add("-u", "root");
        }
        commandBuilder.add(containerId).add(args);
        return commandBuilder.build();
    }

    private static List<DataVolume> remapHomeDirectories(Collection<DataVolume> volumes) {
        return volumes.stream().map(dv -> {
            String containerDirectory = dv.getContainerDirectory();
            String targetDir = containerDirectory.startsWith("~") ? "/tmp/homemountpoints/" + containerDirectory.replaceFirst("~/?", "") + "/123_MOUNTPOINT_321" : containerDirectory;
            String hostDirectory = dv.getHostDirectory().replaceFirst("^~", SystemUtils.USER_HOME);
            return new DataVolume(hostDirectory, targetDir);
        }).collect(Collectors.toList());
    }

    public boolean isRunning(@NotNull ProcessContext processContext, @NotNull Path dockerPath, @NotNull String containerName, @NotNull Path workingDirectory, @NotNull Map<String, String> environment) throws DockerException {
        String output;
        Preconditions.checkState((processContext != null ? 1 : 0) != 0, (Object)"Process context must not be null");
        Preconditions.checkState((dockerPath != null ? 1 : 0) != 0, (Object)"Docker path must not be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)containerName), (Object)"Container name undefined");
        Preconditions.checkState((workingDirectory != null ? 1 : 0) != 0, (Object)"Working directory undefined");
        ProcessCommand inspectCommand = ProcessCommand.builder().add(dockerPath.toAbsolutePath().toString(), "inspect", "--format={{.State.Running}}", containerName).build();
        try {
            output = this.execute(processContext, inspectCommand, workingDirectory, environment);
        }
        catch (ProcessException e) {
            throw new DockerException("Error running Docker inspect command", (Throwable)e);
        }
        return Boolean.parseBoolean(output);
    }

    @Nullable
    public Integer getHostPort(@NotNull ProcessContext processContext, @NotNull Path dockerPath, @NotNull String containerName, @NotNull Integer containerPort, @NotNull Path workingDirectory, @NotNull Map<String, String> environment) throws DockerException {
        String output;
        Preconditions.checkState((processContext != null ? 1 : 0) != 0, (Object)"Process context must not be null");
        Preconditions.checkState((dockerPath != null ? 1 : 0) != 0, (Object)"Docker path must not be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)containerName), (Object)"Container name undefined");
        Preconditions.checkState((containerPort != null ? 1 : 0) != 0, (Object)"Container port undefined");
        Preconditions.checkState((workingDirectory != null ? 1 : 0) != 0, (Object)"Working directory undefined");
        ProcessCommand inspectCommand = ProcessCommand.builder().add(dockerPath.toAbsolutePath().toString(), "inspect").add(String.format("--format='{{(index (index .NetworkSettings.Ports \"%d/tcp\") 0).HostPort}}'", containerPort)).add(containerName).build();
        try {
            output = this.execute(processContext, inspectCommand, workingDirectory, environment);
        }
        catch (ProcessException e) {
            throw new DockerException("Error running Docker inspect command", (Throwable)e);
        }
        return Ints.tryParse((String)output);
    }

    public void remove(@NotNull ProcessContext processContext, @NotNull Path dockerPath, @NotNull String containerName, @NotNull Path workingDirectory, @NotNull Map<String, String> environment) throws DockerException {
        Preconditions.checkState((processContext != null ? 1 : 0) != 0, (Object)"Process context must not be null");
        Preconditions.checkState((dockerPath != null ? 1 : 0) != 0, (Object)"Docker path must not be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)containerName), (Object)"Container name undefined");
        Preconditions.checkState((workingDirectory != null ? 1 : 0) != 0, (Object)"Working directory undefined");
        ProcessCommand removeCommand = ProcessCommand.builder().add(dockerPath.toAbsolutePath().toString(), "rm", "-f", containerName).build();
        try {
            this.execute(processContext, removeCommand, workingDirectory, environment);
        }
        catch (ProcessException e) {
            throw new DockerException("Error running Docker remove command", (Throwable)e);
        }
    }

    @NotNull
    private String execute(@NotNull ProcessContext processContext, @NotNull ProcessCommand command, @NotNull Path workingDir, @NotNull Map<String, String> environmentVariables) throws ProcessException {
        return this.execute(processContext, command, workingDir, environmentVariables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String execute(@NotNull ProcessContext processContext, @NotNull ProcessCommand command, @NotNull Path workingDir, @NotNull Map<String, String> environmentVariables, boolean ignoreError) throws ProcessException {
        BuildLogInterceptor interceptor;
        block4: {
            interceptor = new BuildLogInterceptor();
            try {
                processContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)interceptor);
                ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder().command(command.getCommandList()).workingDirectory(workingDir.toFile());
                externalProcessBuilder.env(environmentVariables);
                ExternalProcess process = this.processService.executeExternalProcess(processContext, externalProcessBuilder);
                int exitCode = process.getHandler().getExitCode();
                if (exitCode == 0) break block4;
                String recentOutput = String.join((CharSequence)"\n", interceptor.getRecentOutput());
                if (ignoreError) {
                    processContext.getBuildLogger().addBuildLogEntry("Exit code: " + exitCode + ", output: " + recentOutput);
                    break block4;
                }
                processContext.getBuildLogger().addErrorLogEntry("Exit code: " + exitCode + ", output: " + recentOutput);
                throw new ProcessException("Error executing " + PasswordMaskingUtils.maskPossiblePasswordValues((String)command.getSafeCommandString(), (VariableContext)processContext.getVariableContext()));
            }
            finally {
                processContext.getBuildLogger().getInterceptorStack().remove((LogInterceptor)interceptor);
            }
        }
        return interceptor.getFinalOutput();
    }

    private static Path createTemporaryFile(String name) {
        SecureTemporaryFiles.FileSpecBuilder builder = SecureTemporaryFiles.builder().setPrefix(name).setExecutable(true);
        try {
            return SecureTemporaryFiles.createPath(builder.build());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class BuildLogInterceptor
    implements LogInterceptor {
        private final Collection<String> recentOutput = new CircularFifoQueue(20);
        private volatile String lastOutputLine;

        private BuildLogInterceptor() {
        }

        public void intercept(@NotNull LogEntry logEntry) {
            this.recentOutput.add("STDOUT:  " + logEntry.getUnstyledLog());
            this.lastOutputLine = logEntry.getUnstyledLog();
        }

        public void interceptError(@NotNull LogEntry logEntry) {
            this.recentOutput.add("STDERR: " + logEntry.getUnstyledLog());
        }

        Collection<String> getRecentOutput() {
            return this.recentOutput;
        }

        @NotNull
        String getFinalOutput() {
            if (this.lastOutputLine == null) {
                throw new NoSuchElementException();
            }
            return this.lastOutputLine;
        }
    }
}

