/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event;

import com.atlassian.bamboo.event.BuildResultEvent;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BuildCanceledEvent
extends BuildResultEvent {
    private static final Logger log = Logger.getLogger(BuildCanceledEvent.class);
    private final Long agentId;
    private final Date cancellationDate;

    public BuildCanceledEvent(Object source, CurrentlyBuilding currentlyBuilding) {
        super(source, currentlyBuilding.getBuildIdentifier().getPlanResultKey());
        BuildCancelledDetails buildCancelledDetails = currentlyBuilding.getBuildCancelledDetails();
        Preconditions.checkArgument((buildCancelledDetails != null ? 1 : 0) != 0, (Object)"BuildCancelledDetails must not be null");
        this.agentId = currentlyBuilding.getBuildAgentId();
        this.cancellationDate = buildCancelledDetails.getCancellationDate();
    }

    @Nullable
    public Long getAgentId() {
        return this.agentId;
    }

    public Date getCancellationDate() {
        return this.cancellationDate;
    }
}

