/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.event.ChainUpdatedEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import org.jetbrains.annotations.NotNull;

@EventName(value="bamboo.plan.branch.configuration.updated")
public class ChainBranchConfigUpdatedEvent
extends ChainUpdatedEvent {
    private final String branchWorkflow;
    private final boolean mergingEnabled;
    private final String integrationStrategy;
    private final String notificationStrategy;
    private final String triggeringOption;

    public ChainBranchConfigUpdatedEvent(Object source, PlanKey planKey, @NotNull BranchMonitoringConfiguration branchMonitoringConfiguration) {
        super(source, planKey);
        this.branchWorkflow = branchMonitoringConfiguration.getPlanBranchWorkflow().getKey();
        this.mergingEnabled = branchMonitoringConfiguration.getDefaultBranchIntegrationConfiguration().isEnabled();
        BranchIntegrationStrategy integrationStrategy = branchMonitoringConfiguration.getDefaultBranchIntegrationConfiguration().getStrategy();
        this.integrationStrategy = integrationStrategy == null ? "" : integrationStrategy.name();
        BranchNotificationStrategy notificationStrategy = branchMonitoringConfiguration.getDefaultBranchNotificationStrategy();
        this.notificationStrategy = notificationStrategy == null ? "" : notificationStrategy.getKey();
        this.triggeringOption = branchMonitoringConfiguration.getBranchTriggeringOption().getKey();
    }

    public String getBranchWorkflow() {
        return this.branchWorkflow;
    }

    public boolean isMergingEnabled() {
        return this.mergingEnabled;
    }

    public String getIntegrationStrategy() {
        return this.integrationStrategy;
    }

    public String getNotificationStrategy() {
        return this.notificationStrategy;
    }

    public String getTriggeringOption() {
        return this.triggeringOption;
    }
}

