/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.api.EventPublisher;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TxAwareEventPublisher
implements EventPublisher {
    private final EventPublisher delegate;

    public TxAwareEventPublisher(EventPublisher eventPublisher) {
        this.delegate = eventPublisher;
    }

    public void publish(Object event) {
        if (event.getClass().getAnnotation(AsynchronousPreferred.class) != null && TransactionSynchronizationManager.isSynchronizationActive()) {
            this.defer(event);
        } else {
            this.delegate.publish(event);
        }
    }

    public void register(Object listener) {
        this.delegate.register(listener);
    }

    public void unregister(Object listener) {
        this.delegate.unregister(listener);
    }

    public void unregisterAll() {
        this.delegate.unregisterAll();
    }

    private void defer(final Object event) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                TxAwareEventPublisher.this.delegate.publish(event);
            }
        });
    }
}

