/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

@AsynchronousPreferred
@EventName(value="bamboo.elastic.instance.started")
public class ElasticInstanceStartedAnalyticsEvent {
    private final OsType os;
    private final AwsSupportConstants.RootDeviceType rootDeviceType;
    private final AwsSupportConstants.Virtualisation virtualisationType;
    private final boolean isStockImage;
    private final boolean hasStartupScript;

    public ElasticInstanceStartedAnalyticsEvent(ElasticImageConfiguration elasticImageConfiguration) {
        this.os = OsType.fromString(elasticImageConfiguration.getOsName());
        this.rootDeviceType = elasticImageConfiguration.getRootDeviceType();
        this.virtualisationType = elasticImageConfiguration.getVirtualisationType();
        this.isStockImage = elasticImageConfiguration.isShippedWithBamboo();
        this.hasStartupScript = elasticImageConfiguration.getStartupScripts().stream().anyMatch(script -> !script.getBody().isEmpty());
    }

    public OsType getOs() {
        return this.os;
    }

    public AwsSupportConstants.RootDeviceType getRootDeviceType() {
        return this.rootDeviceType;
    }

    public AwsSupportConstants.Virtualisation getVirtualisationType() {
        return this.virtualisationType;
    }

    public boolean isStockImage() {
        return this.isStockImage;
    }

    public boolean isHasStartupScript() {
        return this.hasStartupScript;
    }

    public static enum OsType {
        WINDOWS("WINDOWS"),
        UBUNTU("UBUNTU"),
        AMAZON_LINUX("AMAZON LINUX"),
        OTHER("OTHER");

        private final String os;

        private OsType(String os) {
            this.os = os;
        }

        public String getOs() {
            return this.os;
        }

        @NotNull
        public static OsType fromString(String os) {
            return Arrays.stream(OsType.values()).filter(osType -> osType.os.equalsIgnoreCase(os)).findFirst().orElse(OTHER);
        }
    }
}

