/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import org.apache.commons.lang3.StringUtils;

@EventName(value="bamboo.repository.stored.specs.run.log.download")
public class RssLogDownloadEvent {
    private final String referrer;

    public RssLogDownloadEvent(String rawReferrer) {
        this.referrer = Referrer.byName(rawReferrer).getName();
    }

    public String getReferrer() {
        return this.referrer;
    }

    public static enum Referrer {
        EMAIL("email"),
        COMMIT("commit"),
        DIRECT("direct"),
        UNKNOWN("unknown");

        private final String name;

        private Referrer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static Referrer byName(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return DIRECT;
            }
            for (Referrer referrer : Referrer.values()) {
                if (!referrer.getName().equals(name)) continue;
                return referrer;
            }
            return UNKNOWN;
        }
    }
}

