/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bamboo.event.analytics.SpecsType;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;

@EventName(value="bamboo.repository.stored.specs.plan.saved")
@AsynchronousPreferred
public class RssPlanSavedEvent {
    private final long planKeyHash;
    private final PlanResultKey planResultKey;
    private final SpecsType specsType;

    public RssPlanSavedEvent(PlanResultKey planResultKey, SpecsType specsType) {
        this.planResultKey = planResultKey;
        this.planKeyHash = planResultKey.getPlanKey().toString().hashCode();
        this.specsType = specsType;
    }

    public long getPlanKeyHash() {
        return this.planKeyHash;
    }

    public SpecsType getSpecsType() {
        return this.specsType;
    }

    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RssPlanSavedEvent that = (RssPlanSavedEvent)o;
        return this.planResultKey.equals((Object)that.planResultKey) && this.specsType == that.specsType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.planResultKey, this.specsType});
    }
}

