/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.vcs.AnalyticsUtils;
import com.atlassian.event.api.AsynchronousPreferred;
import org.jetbrains.annotations.NotNull;

@EventName(value="bamboo.task.build.started")
@AsynchronousPreferred
public class TaskBuildStartedAnalyticsEvent {
    private final String taskPluginKeyHash;
    private final boolean isAtlassian;
    private final boolean isConditional;

    public TaskBuildStartedAnalyticsEvent(@NotNull TaskDefinition taskDefinition) {
        this.taskPluginKeyHash = TaskBuildStartedAnalyticsEvent.calculatePluginKeyHash(taskDefinition.getPluginKey());
        this.isAtlassian = taskDefinition.getPluginKey().startsWith("com.atlassian");
        this.isConditional = !taskDefinition.getConditions().isEmpty();
    }

    @NotNull
    public static String calculatePluginKeyHash(@NotNull String taskPluginKey) {
        return AnalyticsUtils.anonymizeFreeText(taskPluginKey);
    }

    public String getTaskPluginKeyHash() {
        return this.taskPluginKeyHash;
    }

    public boolean isAtlassian() {
        return this.isAtlassian;
    }

    public boolean isConditional() {
        return this.isConditional;
    }
}

