/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.spi;

import com.atlassian.bamboo.utils.Pair;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EventLoggingThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = Logger.getLogger(EventLoggingThreadPoolExecutor.class);
    private final ConcurrentMap<String, Pair<Runnable, Date>> threadToRunnableMappings = new ConcurrentHashMap<String, Pair<Runnable, Date>>();

    public EventLoggingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public EventLoggingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public EventLoggingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public EventLoggingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to run " + r));
        }
        this.threadToRunnableMappings.put(t.getName(), (Pair<Runnable, Date>)Pair.make((Object)r, (Object)new Date()));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished running " + r));
        }
        this.threadToRunnableMappings.remove(Thread.currentThread().getName());
    }

    public ConcurrentMap<String, Pair<Runnable, Date>> getThreadToRunnableMappings() {
        return this.threadToRunnableMappings;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(final Callable<T> callable) {
        return new FutureTask<T>(callable){

            @Override
            public String toString() {
                return "Future for " + callable;
            }
        };
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(final Runnable runnable, T value) {
        return new FutureTask<T>(runnable, value){

            @Override
            public String toString() {
                return "Future for " + runnable;
            }
        };
    }
}

