/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.spi;

import com.atlassian.bamboo.event.spi.EventLoggingThreadPoolExecutor;
import com.atlassian.bamboo.event.spi.ExecutorStats;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public class ExecutorStatsImpl
implements ExecutorStats {
    private final int activeCount;
    private final int poolSize;
    private final List<Runnable> eventsQueue;
    private final Map<String, Pair<Runnable, Date>> threadToRunnableMappings;

    public ExecutorStatsImpl(EventLoggingThreadPoolExecutor executor) {
        this.activeCount = executor.getActiveCount();
        this.poolSize = executor.getPoolSize();
        this.threadToRunnableMappings = ImmutableMap.copyOf(executor.getThreadToRunnableMappings());
        this.eventsQueue = ImmutableList.copyOf(executor.getQueue());
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    @NotNull
    public List<Runnable> getEventsQueue() {
        return this.eventsQueue;
    }

    @NotNull
    public Map<String, Pair<Runnable, Date>> getThreadToRunnableMappings() {
        return this.threadToRunnableMappings;
    }
}

