/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event.sse;

import com.atlassian.bamboo.event.sse.ServerSentEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerSentEventQueue {
    private static final Logger log = Logger.getLogger(ServerSentEventQueue.class);
    private static final LoadingCache<Long, BlockingQueue<ServerSentEvent>> sessionQueues = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, BlockingQueue<ServerSentEvent>>(){

        public BlockingQueue<ServerSentEvent> load(@NotNull Long key) throws Exception {
            log.info((Object)("Creating a new Server Sent Event queue #" + Long.toHexString(key)));
            return new LinkedBlockingQueue<ServerSentEvent>();
        }
    });

    private ServerSentEventQueue() {
    }

    public static BlockingQueue<ServerSentEvent> getQueue(long sessionId) {
        return (BlockingQueue)sessionQueues.getUnchecked((Object)sessionId);
    }
}

