/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.execution;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.execution.events.DeploymentTimingPoints;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoints;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPointService;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPhaseServiceImpl
implements ExecutionPhaseService {
    private static final Logger log = Logger.getLogger(ExecutionPhaseServiceImpl.class);
    private final TimingPointService timingPointService;

    public ExecutionPhaseServiceImpl(TimingPointService timingPointService) {
        this.timingPointService = timingPointService;
    }

    public void queued(@NotNull CommonContext context) {
        log.info((Object)String.format("%s queued", context.getDisplayName()));
        BuildContext buildContext = this.toBuildContext(context);
        if (buildContext != null) {
            this.timingPointService.publish((TimingPoint)BuildTimingPoints.queued((BuildContext)buildContext, (Date)new Date()));
        } else {
            DeploymentContext deploymentContext = this.toDeploymentContext(context);
            if (deploymentContext != null) {
                this.timingPointService.publish((TimingPoint)DeploymentTimingPoints.queued((DeploymentContext)deploymentContext, (Date)new Date()));
            } else {
                this.illegalContext(context);
            }
        }
    }

    public void agentAssigned(@NotNull CommonContext context, long agentId) {
        log.info((Object)String.format("%s assigned to agent %d", context.getDisplayName(), agentId));
        BuildContext buildContext = this.toBuildContext(context);
        if (buildContext != null) {
            this.timingPointService.publish((TimingPoint)BuildTimingPoints.agentAssigned((PlanResultKey)buildContext.getPlanResultKey(), (Date)new Date(), (long)agentId));
        } else {
            DeploymentContext deploymentContext = this.toDeploymentContext(context);
            if (deploymentContext != null) {
                this.timingPointService.publish((TimingPoint)DeploymentTimingPoints.agentAssigned((DeploymentContext)deploymentContext, (Date)new Date(), (long)agentId));
            } else {
                this.illegalContext(context);
            }
        }
    }

    public void vcsSyncStarted(@NotNull CommonContext context) {
        log.info((Object)String.format("%s VCS sync started", context.getDisplayName()));
        BuildContext buildContext = this.toBuildContext(context);
        if (buildContext != null) {
            this.timingPointService.publish((TimingPoint)BuildTimingPoints.vcsSyncStarted((PlanResultKey)buildContext.getPlanResultKey(), (Date)new Date()));
        }
    }

    public void executionStarted(@NotNull CommonContext context) {
        log.info((Object)String.format("%s execution started", context.getDisplayName()));
        BuildContext buildContext = this.toBuildContext(context);
        if (buildContext != null) {
            this.timingPointService.publish((TimingPoint)BuildTimingPoints.executionStarted((PlanResultKey)buildContext.getPlanResultKey(), (Date)new Date()));
        } else {
            DeploymentContext deploymentContext = this.toDeploymentContext(context);
            if (deploymentContext != null) {
                this.timingPointService.publish((TimingPoint)DeploymentTimingPoints.executionStarted((DeploymentContext)deploymentContext, (Date)new Date()));
            } else {
                this.illegalContext(context);
            }
        }
    }

    public void executionCancelled(@NotNull ResultKey resultKey, @Nullable Long deploymentResultId, boolean buildActuallyCancelled) {
        log.info((Object)String.format("%s execution cancelled", resultKey));
        if (resultKey instanceof PlanResultKey) {
            this.timingPointService.publish((TimingPoint)BuildTimingPoints.executionCancelled((PlanResultKey)((PlanResultKey)resultKey), (Date)new Date(), (boolean)buildActuallyCancelled));
        } else if (resultKey instanceof DeploymentResultKey) {
            this.timingPointService.publish((TimingPoint)DeploymentTimingPoints.executionCancelled((Long)((Long)Preconditions.checkNotNull((Object)deploymentResultId)), (Date)new Date(), (boolean)buildActuallyCancelled));
        } else {
            throw new IllegalStateException(String.format("Illegal resultKey of class %s", resultKey.getClass().getName()));
        }
    }

    public void executionFinished(@NotNull CommonContext context) {
        log.info((Object)String.format("%s execution finished", context.getDisplayName()));
        BuildContext buildContext = this.toBuildContext(context);
        if (buildContext != null) {
            this.timingPointService.publish((TimingPoint)BuildTimingPoints.executionFinished((PlanResultKey)buildContext.getPlanResultKey(), (Date)new Date()));
        } else {
            DeploymentContext deploymentContext = this.toDeploymentContext(context);
            if (deploymentContext != null) {
                this.timingPointService.publish((TimingPoint)DeploymentTimingPoints.executionFinished((DeploymentContext)deploymentContext, (Date)new Date()));
            } else {
                this.illegalContext(context);
            }
        }
    }

    @Nullable
    private BuildContext toBuildContext(@NotNull CommonContext context) {
        return (BuildContext)Narrow.downTo((Object)context, BuildContext.class);
    }

    @Nullable
    private DeploymentContext toDeploymentContext(@NotNull CommonContext context) {
        return (DeploymentContext)Narrow.downTo((Object)context, DeploymentContext.class);
    }

    private void illegalContext(@NotNull CommonContext context) {
        throw new IllegalStateException(String.format("Illegal context of class %s", context.getClass().getName()));
    }
}

