/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.executor;

import com.google.common.base.Preconditions;
import java.time.Duration;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public abstract class InterruptThreadWatchdog
implements TimeoutObserver {
    private static final Logger log = Logger.getLogger(InterruptThreadWatchdog.class);
    @GuardedBy(value="this")
    private final Thread thread;
    private final long timeoutSeconds;
    @GuardedBy(value="this")
    private final Watchdog watchdog;
    @GuardedBy(value="this")
    private boolean threadInterrupted = false;

    public InterruptThreadWatchdog(long timeoutSeconds, @NotNull Thread thread) {
        Preconditions.checkArgument((timeoutSeconds > 0L ? 1 : 0) != 0, (Object)"Timeout must be > 0");
        Preconditions.checkArgument((thread != null ? 1 : 0) != 0);
        this.thread = thread;
        this.timeoutSeconds = timeoutSeconds;
        this.watchdog = new Watchdog(Duration.ofSeconds(this.timeoutSeconds).toMillis());
        this.watchdog.addTimeoutObserver((TimeoutObserver)this);
    }

    public synchronized void start() {
        this.watchdog.start();
    }

    public synchronized void stop() {
        this.watchdog.stop();
    }

    public synchronized void timeoutOccured(Watchdog w) {
        try {
            this.onBeforeInterrupt(this.thread);
            this.thread.interrupt();
            this.threadInterrupted = true;
        }
        catch (Exception e) {
            log.error((Object)("Unable to interrupt thread: " + this.thread.getName()), (Throwable)e);
        }
    }

    protected abstract void onBeforeInterrupt(Thread var1);

    public synchronized boolean isThreadInterrupted() {
        return this.threadInterrupted;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }
}

