/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.Nullable;

public class NamedExecutors {
    private NamedExecutors() {
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName) {
        return Executors.newScheduledThreadPool(corePoolSize, new NamingThreadFactory(Executors.defaultThreadFactory(), poolName));
    }

    public static ExecutorService newNamedSingleThreadExecutor(String name) {
        return Executors.newSingleThreadExecutor(new NamingThreadFactory(Executors.defaultThreadFactory(), name));
    }

    private static class NamingThreadFactory
    implements ThreadFactory {
        private final ThreadFactory threadFactory;
        private final String poolName;

        public NamingThreadFactory(ThreadFactory threadFactory, String poolName) {
            this.threadFactory = threadFactory;
            this.poolName = poolName;
        }

        @Override
        @Nullable
        public Thread newThread(Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            if (thread != null) {
                thread.setName(this.poolName + "-" + thread.getName());
                thread.setDaemon(true);
            }
            return thread;
        }
    }
}

