/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.executor;

import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.utils.Comparators;
import java.time.Duration;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RetryingTaskExecutor<T> {
    private static final Logger log = Logger.getLogger(RetryingTaskExecutor.class);
    public static final Duration DEFAULT_MAX_RETRY_DELAY = Duration.ofMinutes(1L);
    public static final int DEFAULT_MAX_RETRIES = 10;
    public static final Duration DEFAULT_INITIAL_RETRY_DELAY = Duration.ofSeconds(1L);
    public static final int DEFAULT_BACK_OFF_MULTIPLIER = 2;
    private final Duration initialRetryDelay;
    private final Duration maxRetryDelay;
    private final int maxRetries;
    private final boolean useExponentialBackOff;
    private final long backOffMultiplier;
    private final boolean rethrowLastException;
    protected volatile T objectToReturn;
    private int failures;

    public RetryingTaskExecutor(Duration initialRetryDelay, Duration maxRetryDelay, int maxRetries, long backOffMultiplier, boolean useExponentialBackOff, boolean rethrowLastException) {
        this.initialRetryDelay = initialRetryDelay;
        this.maxRetryDelay = maxRetryDelay;
        this.maxRetries = maxRetries;
        this.useExponentialBackOff = useExponentialBackOff;
        this.backOffMultiplier = backOffMultiplier;
        this.rethrowLastException = rethrowLastException;
    }

    public RetryingTaskExecutor(Duration initialRetryDelay, int maxRetries) {
        this(initialRetryDelay, DEFAULT_MAX_RETRY_DELAY, maxRetries, 2L, true, false);
    }

    public RetryingTaskExecutor(int maxRetries, boolean rethrowLastException) {
        this(DEFAULT_INITIAL_RETRY_DELAY, DEFAULT_MAX_RETRY_DELAY, maxRetries, 2L, true, rethrowLastException);
    }

    public RetryingTaskExecutor(Duration initialRetryDelay, int maxRetries, boolean useExponentialBackOff) {
        this(initialRetryDelay, DEFAULT_MAX_RETRY_DELAY, maxRetries, 2L, useExponentialBackOff, false);
    }

    public RetryingTaskExecutor() {
        this(DEFAULT_INITIAL_RETRY_DELAY, DEFAULT_MAX_RETRY_DELAY, 10, 2L, true, false);
    }

    @Deprecated
    public RetryingTaskExecutor(long initialRetryDelayMs, long maxRetryDelay, int maxRetries, long backOffMultiplier, boolean useExponentialBackOff, boolean rethrowLastException) {
        this(Duration.ofMillis(initialRetryDelayMs), Duration.ofMillis(maxRetryDelay), maxRetries, backOffMultiplier, useExponentialBackOff, rethrowLastException);
    }

    @Deprecated
    public RetryingTaskExecutor(long initialRetryDelayMs, int maxRetries) {
        this(Duration.ofMillis(initialRetryDelayMs), maxRetries);
    }

    @Deprecated
    public RetryingTaskExecutor(long initialRetryDelayMs, int maxRetries, boolean useExponentialBackOff) {
        this(Duration.ofMillis(initialRetryDelayMs), maxRetries, useExponentialBackOff);
    }

    public void runTask(@NotNull Callable<T> task) {
        this.runTask(task.getClass().getName(), task);
    }

    public void runTask(String taskName, @NotNull Callable<T> callable) {
        this.runTask(taskName, callable, exception -> true);
    }

    private void runTask(String taskDescription, @NotNull Callable<T> callable, @NotNull Predicate<Exception> shouldRetry) {
        boolean run = true;
        Duration retryDelay = this.initialRetryDelay;
        while (run) {
            run = this.rerun(callable, taskDescription, retryDelay, shouldRetry);
            if (!this.useExponentialBackOff || !Comparators.isGreater(retryDelay = retryDelay.multipliedBy(this.backOffMultiplier), this.maxRetryDelay, Comparator.naturalOrder())) continue;
            retryDelay = this.maxRetryDelay;
        }
    }

    private boolean rerun(@NotNull Callable<T> task, String taskName, Duration retryDelay, @NotNull Predicate<Exception> shouldRetry) {
        try {
            this.objectToReturn = task.call();
            if (this.failures > 0) {
                log.info((Object)("Task '" + taskName + "' finished successfully during retry number " + this.failures));
            }
            return false;
        }
        catch (CancelException e) {
            log.error((Object)("Canceled task '" + taskName));
            if (this.rethrowLastException) {
                log.error((Object)"Exception being rethrown");
                throw new RuntimeException(e);
            }
            log.error((Object)"Final exception was ", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            if (!shouldRetry.test(e)) {
                log.info((Object)("Task '" + taskName + "' threw " + e + ", aborting."));
                throw new RuntimeException(e);
            }
            ++this.failures;
            String exceptionMessage = BambooStringUtils.truncateAndAddEllipsis((String)e.getMessage(), (int)100);
            log.info((Object)String.format("Task '%s' was unsuccessful. Run %d / %d. Exception thrown when running task '%s', with message: %s", taskName, this.failures, this.maxRetries, taskName, exceptionMessage));
            log.debug((Object)"Full stack trace: ", (Throwable)e);
            if (this.failures >= this.maxRetries) {
                String message = "Failed to run task '" + taskName + "' after " + this.failures + " attempts. Task was not executed.";
                if (this.rethrowLastException) {
                    log.error((Object)(message + " Rethrowing exception."));
                    throw new RuntimeException(e);
                }
                log.error((Object)(message + " The final exception was:"), (Throwable)e);
                return false;
            }
            log.info((Object)("Waiting " + retryDelay + "ms before retrying..."));
            try {
                Thread.sleep(retryDelay.toMillis());
                return true;
            }
            catch (InterruptedException inter) {
                log.warn((Object)"Retry was interrupted! Task was not run.");
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    public T getObjectToReturn() {
        return this.objectToReturn;
    }

    @Deprecated
    public static <T> T retry(String message, int retries, long initialRetryDelayMs, Callable<T> call) {
        return RetryingTaskExecutor.retry(message, retries, Duration.ofMillis(initialRetryDelayMs), call);
    }

    public static <T> T retry(String message, int retries, Duration initialRetryDelay, Callable<T> call) {
        return RetryingTaskExecutor.retry(message, retries, initialRetryDelay, call, (Exception exception) -> true);
    }

    @Deprecated
    public static <T> T retry(@NotNull String message, int retries, long initialRetryDelayMs, @NotNull Callable<T> call, @NotNull com.google.common.base.Predicate<Exception> shouldRetry) {
        return RetryingTaskExecutor.retry(message, retries, Duration.ofMillis(initialRetryDelayMs), call, arg_0 -> shouldRetry.apply(arg_0));
    }

    public static <T> T retry(@NotNull String message, int retries, Duration initialRetryDelay, @NotNull Callable<T> call, @NotNull Predicate<Exception> shouldRetry) {
        RetryingTaskExecutor<T> taskExecutor = new RetryingTaskExecutor<T>(initialRetryDelay, DEFAULT_MAX_RETRY_DELAY, retries, 2L, true, true);
        super.runTask(message, call, shouldRetry);
        return taskExecutor.getObjectToReturn();
    }

    public static Duration randomInitialDelay() {
        return DEFAULT_INITIAL_RETRY_DELAY.minusMillis((long)(Math.random() * (double)DEFAULT_INITIAL_RETRY_DELAY.toMillis()));
    }
}

