/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.executor;

import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SystemSecurityContextExecutors {
    private static final Logger log = Logger.getLogger(SystemSecurityContextExecutors.class);

    private SystemSecurityContextExecutors() {
    }

    public static ListeningExecutorService newFixedThreadPool(int nThreads, @NotNull String threadPoolName) {
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(nThreads, (ThreadFactory)new SystemAuthorityThreadFactory(threadPoolName)));
    }

    public static ListeningExecutorService newSingleThreadExecutor(@NotNull String threadPoolName) {
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new SystemAuthorityThreadFactory(threadPoolName)));
    }

    public static ListeningExecutorService newSingleThreadExecutor(int maxQueueSize, @NotNull String threadPoolName) {
        return MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxQueueSize), (ThreadFactory)new SystemAuthorityThreadFactory(threadPoolName), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    public static ListeningExecutorService newThreadPool(int nThreads, @NotNull String threadPoolName) {
        return MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new SystemAuthorityThreadFactory(threadPoolName), new ThreadPoolExecutor.CallerRunsPolicy()));
    }
}

