/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fieldvalue;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.build.strategy.BuildStrategy;
import com.atlassian.bamboo.build.strategy.BuildStrategyManager;
import com.atlassian.bamboo.build.strategy.ManualBuildStrategy;
import com.atlassian.bamboo.fieldvalue.ConvertibleFromConfig;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchSpecificConfiguration;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.BuildDefinitionTransformerModuleDescriptor;
import com.atlassian.bamboo.plugin.module.ext.CustomBuildDefinitionTransformer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildDefinitionConverter {
    private static final Logger log = Logger.getLogger(BuildDefinitionConverter.class);
    public static final String INHERIT_REPOSITORY = "inheritRepository";
    @Deprecated
    public static final String SELECTED_BUILD_STRATEGY = "selectedBuildStrategy";
    public static final String REPOSITORY_DEFINING_WORKING_DIRECTORY = "repositoryDefiningWorkingDirectory";
    public static final String BUILD_POLLING = "repository.change.poll.pollingPeriod";
    public static final String BUILD_TRIGGER_IP = "repository.change.trigger.triggerIpAddress";
    public static final String SELECTED_BUILDER_KEY = "selectedBuilderCompleteKey";
    public static final String DEPENDENT_WILL_TRIGGER = "dependencies.dependent";
    public static final String DEPENDENT_WILL_BE_TRIGGERED_BY = "dependencies.parent";
    public static final String CLEAN_WORKING_DIRECTORY = "cleanWorkingDirectory";
    private final PluginAccessor pluginAccessor;

    public BuildDefinitionConverter(@NotNull PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public XMLConfiguration fromObject(@NotNull PartialBuildDefinition buildDefinition) {
        Preconditions.checkArgument((buildDefinition != null ? 1 : 0) != 0);
        XMLConfiguration config = ConfigUtils.newConfiguration();
        config.setProperty("isMergedConfiguration", (Object)buildDefinition.isMerged());
        this.setOptionalProperty(config, CLEAN_WORKING_DIRECTORY, buildDefinition.isCleanWorkingDirectory());
        this.setOptionalProperty(config, REPOSITORY_DEFINING_WORKING_DIRECTORY, buildDefinition.getRepositoryIdDefiningWorkingDir());
        TaskConfigurationUtils.addTaskDefinitionsToConfig(buildDefinition.getTaskDefinitions(), (HierarchicalConfiguration)config, "buildTasks.");
        TriggerConfigurationUtils.addTriggerDefinitionsToConfig(buildDefinition.getTriggerDefinitions(), (HierarchicalConfiguration)config);
        this.copyOptionalNodes(config, (ConvertibleFromConfig)buildDefinition.getBranchMonitoringConfiguration());
        this.copyOptionalNodes(config, (ConvertibleFromConfig)buildDefinition.getBranchIntegrationConfiguration());
        this.copyOptionalNodes(config, (ConvertibleFromConfig)buildDefinition.getBranchSpecificConfiguration());
        this.copyOptionalNodes(config, (ConvertibleFromConfig)buildDefinition.getDockerPipelineConfiguration());
        this.copyOptionalMap(config, buildDefinition.getCustomConfiguration());
        return config;
    }

    private void copyOptionalMap(@NotNull XMLConfiguration config, @Nullable Map<String, String> map) {
        if (map != null) {
            ConfigUtils.copyMapToConfig(map, (Configuration)config);
        }
    }

    private void setOptionalProperty(XMLConfiguration config, @NotNull String propertyName, @Nullable Object object) {
        if (object != null) {
            config.setProperty(propertyName, object);
        }
    }

    private void copyOptionalNodes(@NotNull XMLConfiguration config, @Nullable ConvertibleFromConfig convertibleFromConfig) {
        if (convertibleFromConfig != null) {
            ConfigUtils.copyNodes((HierarchicalConfiguration)convertibleFromConfig.toConfiguration(), (HierarchicalConfiguration)config);
        }
    }

    @NotNull
    public BuildDefinition copyConfigurationToDefinition(@NotNull HierarchicalConfiguration fromConfig, @NotNull BuildDefinition buildDefinition) {
        DockerPipelineConfiguration dockerPipelineConfiguration;
        List<TaskDefinition> taskDefinitions;
        BranchSpecificConfiguration branchSpecificConfiguration;
        BranchIntegrationConfiguration branchIntegrationConfiguration;
        BranchMonitoringConfiguration branchMonitoringConfiguration;
        Preconditions.checkArgument((fromConfig != null ? 1 : 0) != 0);
        Preconditions.checkArgument((buildDefinition != null ? 1 : 0) != 0);
        if (fromConfig.containsKey(CLEAN_WORKING_DIRECTORY)) {
            buildDefinition.setCleanWorkingDirectory(fromConfig.getBoolean(CLEAN_WORKING_DIRECTORY, false));
        }
        if (fromConfig.containsKey(REPOSITORY_DEFINING_WORKING_DIRECTORY)) {
            buildDefinition.setRepositoryIdDefiningWorkingDir(fromConfig.getLong(REPOSITORY_DEFINING_WORKING_DIRECTORY, -1L));
        }
        if (fromConfig.getBoolean("triggers.defined", false) && AgentTypeHolder.get() == AgentType.LOCAL) {
            buildDefinition.setTriggerDefinitions(TriggerConfigurationUtils.getTriggerDefinitionsFromConfig(fromConfig));
        }
        if ((branchMonitoringConfiguration = (BranchMonitoringConfiguration)BuildDefinitionConverter.populate(fromConfig, new BranchMonitoringConfigurationImpl())) != null) {
            buildDefinition.setBranchMonitoringConfiguration(branchMonitoringConfiguration);
        }
        if ((branchIntegrationConfiguration = (BranchIntegrationConfiguration)BuildDefinitionConverter.populate(fromConfig, new BranchIntegrationConfigurationImpl())) != null) {
            buildDefinition.setBranchIntegrationConfiguration(branchIntegrationConfiguration);
        }
        if ((branchSpecificConfiguration = BuildDefinitionConverter.populate(fromConfig, new BranchSpecificConfiguration())) != null) {
            buildDefinition.setBranchSpecificConfiguration(branchSpecificConfiguration);
        }
        if (!(taskDefinitions = TaskConfigurationUtils.getTaskDefinitionsFromConfig("buildTasks.", fromConfig)).isEmpty()) {
            buildDefinition.setTaskDefinitions(taskDefinitions);
        }
        if ((dockerPipelineConfiguration = (DockerPipelineConfiguration)BuildDefinitionConverter.populate(fromConfig, new DockerPipelineConfigurationImpl())) != null) {
            buildDefinition.setDockerPipelineConfiguration(dockerPipelineConfiguration);
        }
        Map newCustomConfiguration = ConfigUtils.asMap((Configuration)fromConfig, (String)"custom");
        Map existingCustomConfiguration = buildDefinition.getCustomConfiguration();
        if (existingCustomConfiguration != null) {
            existingCustomConfiguration.putAll(newCustomConfiguration);
        } else {
            buildDefinition.setCustomConfiguration(newCustomConfiguration);
        }
        if (buildDefinition.getConfigObjects() == null) {
            buildDefinition.setConfigObjects(new HashMap());
        }
        for (CustomBuildDefinitionTransformer transformer : this.getTransformers()) {
            transformer.transformBuildDefinition(buildDefinition.getConfigObjects(), buildDefinition.getCustomConfiguration(), buildDefinition);
        }
        if (BuildConfiguration.isMerged((HierarchicalConfiguration)fromConfig)) {
            buildDefinition.setMerged(true);
        }
        return buildDefinition;
    }

    private List<CustomBuildDefinitionTransformer> getTransformers() {
        return Lists.transform(this.getTransformerDescriptors(), BambooPluginUtils::instantiateModule);
    }

    public List<BuildDefinitionTransformerModuleDescriptor> getTransformerDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(BuildDefinitionTransformerModuleDescriptor.class);
    }

    @Nullable
    public static <T extends OptionallyConvertibleFromConfig> T populate(@NotNull HierarchicalConfiguration fromConfig, @NotNull T optionallyConvertibleFromConfig) {
        optionallyConvertibleFromConfig.populateFromConfig(fromConfig);
        if (!optionallyConvertibleFromConfig.isValid()) {
            return null;
        }
        return optionallyConvertibleFromConfig;
    }

    @Deprecated
    @Nullable
    public static List<BuildStrategy> createBuildStrategiesListFromOldConfigurationFormat(@NotNull BuildStrategyManager buildStrategyManager, @NotNull HierarchicalConfiguration fromConfig) {
        String buildStrategyKey = fromConfig.getString(SELECTED_BUILD_STRATEGY);
        if (buildStrategyKey != null) {
            ArrayList<BuildStrategy> buildStrategies = new ArrayList<BuildStrategy>();
            BuildStrategy buildStrategy = buildStrategyManager.getNewBuildStrategyInstance(buildStrategyKey);
            if (!(buildStrategy instanceof ManualBuildStrategy)) {
                buildStrategy.populateFromConfig(fromConfig);
                buildStrategies.add(buildStrategy);
            }
            return buildStrategies;
        }
        return null;
    }
}

