/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fieldvalue;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.strategy.BuildStrategy;
import com.atlassian.bamboo.build.strategy.BuildStrategyManager;
import com.atlassian.bamboo.build.strategy.RepositoryAwareBuildStrategy;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@Internal
public class BuildStrategyConfigurationUtils {
    private static final Logger log = Logger.getLogger(BuildStrategyConfigurationUtils.class);
    public static final String BUILD_STRATEGY_CONFIG_ROOT = "buildStrategies";
    public static final String BUILD_STRATEGY_PREFIX = "buildStrategies.";
    public static final String BUILD_STRATEGIES_DEFINED = "buildStrategies.defined";
    private static final String TRIGGERING_REPOSITORIES = "triggeringRepositories";

    private BuildStrategyConfigurationUtils() {
    }

    public static void addBuildStrategiesToConfig(@Nullable List<BuildStrategy> buildStrategies, @NotNull HierarchicalConfiguration config) {
        config.clearTree(BUILD_STRATEGY_CONFIG_ROOT);
        if (buildStrategies == null) {
            return;
        }
        config.addProperty(BUILD_STRATEGIES_DEFINED, (Object)true);
        for (BuildStrategy buildStrategy : buildStrategies) {
            config.addProperty("buildStrategies.buildStrategy(-1).id", (Object)buildStrategy.getId());
            config.addProperty("buildStrategies.buildStrategy.key", (Object)buildStrategy.getKey());
            config.addProperty("buildStrategies.buildStrategy.name", (Object)buildStrategy.getUserDescription());
            RepositoryAwareBuildStrategy rabs = (RepositoryAwareBuildStrategy)Narrow.downTo((Object)buildStrategy, RepositoryAwareBuildStrategy.class);
            if (rabs != null) {
                config.addProperty("buildStrategies.buildStrategy.triggeringRepositories", (Object)BuildStrategyConfigurationUtils.triggeringRepositoriesToString(rabs.getTriggeringRepositories()));
            }
            Map configuration = ConfigUtils.asMap((Configuration)buildStrategy.toConfiguration(), null);
            for (Map.Entry entry : configuration.entrySet()) {
                config.addProperty("buildStrategies.buildStrategy.config.item(-1).key", entry.getKey());
                config.addProperty("buildStrategies.buildStrategy.config.item.value", entry.getValue());
            }
        }
    }

    @Nullable
    public static List<BuildStrategy> getBuildStrategiesFromConfig(BuildStrategyManager buildStrategyManager, HierarchicalConfiguration fromConfig) {
        if (!fromConfig.getBoolean(BUILD_STRATEGIES_DEFINED, false)) {
            return null;
        }
        ArrayList<BuildStrategy> buildStrategies = new ArrayList<BuildStrategy>();
        List buildStrategyConfigs = fromConfig.configurationsAt("buildStrategies.buildStrategy");
        if (buildStrategyConfigs != null) {
            for (Object buildStrategyNode : buildStrategyConfigs) {
                SubnodeConfiguration buildStrategyCfg = (SubnodeConfiguration)buildStrategyNode;
                String buildStrategyKey = BambooInterners.moduleKey((String)buildStrategyCfg.getString("key"));
                HashMap<String, String> buildStrategyConfigMap = new HashMap<String, String>();
                List configItems = buildStrategyCfg.configurationsAt("config.item");
                for (Object configItemObject : configItems) {
                    SubnodeConfiguration configItem = (SubnodeConfiguration)configItemObject;
                    String key = BambooInterners.intern((String)configItem.getString("key"));
                    String value = BambooInterners.intern((String)configItem.getString("value"));
                    buildStrategyConfigMap.put(key, value);
                }
                BuildStrategy buildStrategy = buildStrategyManager.getNewBuildStrategyInstance(buildStrategyKey);
                RepositoryAwareBuildStrategy rabs = (RepositoryAwareBuildStrategy)Narrow.downTo((Object)buildStrategy, RepositoryAwareBuildStrategy.class);
                if (rabs != null && buildStrategyCfg.containsKey(TRIGGERING_REPOSITORIES)) {
                    String triggeringRepositoriesString = buildStrategyCfg.getString(TRIGGERING_REPOSITORIES);
                    rabs.setTriggeringRepositories(BuildStrategyConfigurationUtils.extractTriggeringRepositoriesFromCfgString(triggeringRepositoriesString));
                }
                XMLConfiguration hc = ConfigUtils.newConfiguration();
                ConfigUtils.copyMapToConfig(buildStrategyConfigMap, (Configuration)hc);
                buildStrategy.populateFromConfig((HierarchicalConfiguration)hc);
                buildStrategy.setUserDescription(BambooInterners.intern((String)buildStrategyCfg.getString("name", buildStrategy.getName())));
                buildStrategy.setId(buildStrategyCfg.getLong("id", 0L));
                buildStrategies.add(buildStrategy);
            }
        }
        return buildStrategies;
    }

    @NotNull
    public static List<BuildStrategy> getBuildStrategiesFromConfigNotNull(BuildStrategyManager buildStrategyManager, HierarchicalConfiguration fromConfig) {
        List<BuildStrategy> buildStrategies = BuildStrategyConfigurationUtils.getBuildStrategiesFromConfig(buildStrategyManager, fromConfig);
        return (List)MoreObjects.firstNonNull(buildStrategies, Collections.emptyList());
    }

    @NotNull
    public static Set<Long> extractTriggeringRepositoriesFromCfgString(@NotNull String triggeringRepositoriesString) {
        return BambooIterables.stream((Iterable)Splitter.on((String)",").split((CharSequence)triggeringRepositoriesString)).filter(StringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toCollection(HashSet::new));
    }

    @NotNull
    private static String triggeringRepositoriesToString(@NotNull Set<Long> triggeringRepositories) {
        return Joiner.on((String)",").join(triggeringRepositories);
    }

    public static BuildStrategy createNewBuildStrategy(BuildStrategyManager buildStrategyManager, HierarchicalConfiguration configuration, String userDescription, long buildStrategyId, Set<Long> triggeringRepositories) {
        String buildStrategyKey = configuration.getString("selectedBuildStrategy");
        BuildStrategy newBuildStrategy = buildStrategyManager.getNewBuildStrategyInstance(buildStrategyKey);
        newBuildStrategy.populateFromConfig(configuration);
        newBuildStrategy.setUserDescription(userDescription);
        newBuildStrategy.setId(buildStrategyId);
        RepositoryAwareBuildStrategy rabs = (RepositoryAwareBuildStrategy)Narrow.downTo((Object)newBuildStrategy, RepositoryAwareBuildStrategy.class);
        if (rabs != null) {
            rabs.setTriggeringRepositories(triggeringRepositories);
        }
        return newBuildStrategy;
    }

    public static long getNewBuildStrategyId(List<BuildStrategy> buildStrategies) {
        long max = 0L;
        for (BuildStrategy definition : buildStrategies) {
            max = Math.max(max, definition.getId());
        }
        return max + 1L;
    }
}

