/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fieldvalue;

import com.atlassian.bamboo.fieldvalue.FieldValueItem;
import com.atlassian.bamboo.fieldvalue.FieldValueItemHolder;
import com.atlassian.bamboo.utils.map.FilteredMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DefaultFieldValueItemHolder
implements FieldValueItemHolder {
    private static final Logger log = Logger.getLogger(DefaultFieldValueItemHolder.class);
    private MultiKeyMap multiKeyMap = new MultiKeyMap();

    public DefaultFieldValueItemHolder() {
    }

    public DefaultFieldValueItemHolder(List fieldValueItems) {
        this.setFieldValueItems(fieldValueItems);
    }

    public void setFieldValueItem(FieldValueItem fieldValueItem) {
        if (log.isInfoEnabled() && this.multiKeyMap.containsKey((Object)fieldValueItem.getKey(), (Object)fieldValueItem.getRow())) {
            FieldValueItem o = (FieldValueItem)this.multiKeyMap.get((Object)fieldValueItem.getKey(), (Object)fieldValueItem.getRow());
            log.info((Object)("Setting field with key '" + fieldValueItem.getKey() + "' and row '" + fieldValueItem.getRow() + "' Over-rides value: " + o.getValue()));
        }
        this.multiKeyMap.put((Object)fieldValueItem.getKey(), (Object)fieldValueItem.getRow(), (Object)fieldValueItem);
    }

    public void setProperty(String key, String value) {
        FieldValueItem fieldValueItem = new FieldValueItem(key, value);
        this.setFieldValueItem(fieldValueItem);
    }

    public void setFieldValueItem(String key, String value, int row) {
        FieldValueItem fieldValueItem = new FieldValueItem(key, value, row);
        this.setFieldValueItem(fieldValueItem);
    }

    public void setFieldValueItem(String key, int value) {
        String stringValue = String.valueOf(value);
        this.setProperty(key, stringValue);
    }

    public void setFieldValueItem(String key, boolean value) {
        String stringValue = String.valueOf(value);
        this.setProperty(key, stringValue);
    }

    public void setFieldValueItems(FieldValueItemHolder fieldValueItemHolder) {
        List list = fieldValueItemHolder.asList();
        for (FieldValueItem fieldValueItem : list) {
            this.setFieldValueItem(fieldValueItem);
        }
    }

    public void setFieldValueItems(String key, List values) {
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                FieldValueItem fieldValueItem = new FieldValueItem(key, value, i);
                this.setFieldValueItem(fieldValueItem);
            }
        }
    }

    public void setFieldValueItems(List<?> fieldValueItems) {
        fieldValueItems.forEach(fieldValueItem -> this.setFieldValueItem((FieldValueItem)fieldValueItem));
    }

    public void setFieldValueItems(Map params) {
        params.forEach((key, value) -> this.setProperty((String)key, (String)value));
    }

    public void addFieldValueItems(String keyField, FieldValueItemHolder fieldValueItemHolder) {
        int row = 0;
        boolean foundRow = false;
        while (!foundRow) {
            FieldValueItem fieldItemValue = this.getFieldItemValue(keyField, row);
            if (fieldItemValue == null) {
                foundRow = true;
                continue;
            }
            ++row;
        }
        List list = fieldValueItemHolder.asList();
        for (FieldValueItem item : list) {
            item.setRow(row);
            this.setFieldValueItem(item);
        }
    }

    public List asList() {
        Collection collection = this.multiKeyMap.values();
        return new ArrayList(collection);
    }

    public FilteredMap asFilteredMap(String prefix) {
        List list = this.asList();
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (FieldValueItem fieldValueItem : list) {
            String key = fieldValueItem.getKey();
            if (!key.startsWith(prefix + ".")) continue;
            map.put(key, fieldValueItem.getValue());
        }
        return new FilteredMap(prefix, map);
    }

    public String getString(String key) {
        FieldValueItem fieldValueItem = this.getFieldItemValue(key, DEFAULT_ROW);
        if (fieldValueItem != null) {
            return fieldValueItem.getValue();
        }
        return null;
    }

    public int getInt(String key) {
        String s = this.getString(key);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public boolean getBoolean(String key) {
        String s = this.getString(key);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return new Boolean(s);
        }
        return false;
    }

    public String getString(String key, Integer row) {
        FieldValueItem fieldItemValue = this.getFieldItemValue(key, row);
        if (fieldItemValue != null) {
            return fieldItemValue.getValue();
        }
        return null;
    }

    public List getListOfStrings(String key) {
        ArrayList<String> returnList = new ArrayList<String>();
        int i = 0;
        FieldValueItem item = this.getFieldItemValue(key, i);
        while (item != null) {
            returnList.add(item.getValue());
            item = this.getFieldItemValue(key, ++i);
        }
        return returnList;
    }

    public FieldValueItem getFieldItemValue(String key, Integer row) {
        FieldValueItem fieldValueItem = (FieldValueItem)this.multiKeyMap.get((Object)key, (Object)row);
        return fieldValueItem;
    }
}

