/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fieldvalue;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityOidService;
import com.atlassian.bamboo.core.ImmutableEntityWithOid;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConditionConfigImpl;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.TaskRootDirectoryType;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskConfigurationUtils {
    private static final Logger log = Logger.getLogger(TaskConfigurationUtils.class);
    public static final String TASK_CONFIG_ROOT = "buildTasks";
    public static final String TASK_PREFIX = "buildTasks.";

    private TaskConfigurationUtils() {
    }

    public static void removeTasksFromConfig(HierarchicalConfiguration config) {
        config.clearTree(TASK_CONFIG_ROOT);
    }

    public static void addTaskDefinitionsToConfig(@Nullable List<TaskDefinition> taskDefinitions, @NotNull HierarchicalConfiguration config, @NotNull String taskPrefix) {
        if (taskDefinitions == null) {
            return;
        }
        for (TaskDefinition taskDefinition : taskDefinitions) {
            if (taskDefinition.getOid() == null) {
                BambooEntityOid bambooEntityOid = ((BambooEntityOidService)ComponentAccessor.BAMBOO_ENTITY_OID_SERVICE.get()).nextOid(taskDefinition.getEntityType());
                taskDefinition.setOid(bambooEntityOid);
            }
            config.addProperty(taskPrefix + "taskDefinition(-1).id", (Object)taskDefinition.getId());
            config.addProperty(taskPrefix + "taskDefinition.userDescription", (Object)taskDefinition.getUserDescription());
            config.addProperty(taskPrefix + "taskDefinition.isEnabled", (Object)taskDefinition.isEnabled());
            for (TaskConditionConfig condition : taskDefinition.getConditions()) {
                String conditionPrefix = taskPrefix + "taskDefinition.conditions.condition";
                config.addProperty(conditionPrefix + "(-1).pluginKey", (Object)condition.getConditionPluginKey());
                ConfigUtils.addMapToConfiguration((String)(conditionPrefix + ".config"), (String)"item", (Map)condition.getConfiguration(), (HierarchicalConfiguration)config);
            }
            config.addProperty(taskPrefix + "taskDefinition.pluginKey", (Object)taskDefinition.getPluginKey());
            config.addProperty(taskPrefix + "taskDefinition.finalising", (Object)taskDefinition.isFinalising());
            config.addProperty(taskPrefix + "taskDefinition.rootDirectoryType", (Object)taskDefinition.getRootDirectorySelector().getTaskRootDirectoryType().toString());
            config.addProperty(taskPrefix + "taskDefinition.repositoryDefiningWorkingDir", (Object)taskDefinition.getRootDirectorySelector().getRepositoryDefiningWorkingDirectory());
            config.addProperty(taskPrefix + "taskDefinition.oid", (Object)taskDefinition.getOid().getValue());
            ConfigUtils.addMapToConfiguration((String)(taskPrefix + "taskDefinition.config"), (String)"item", (Map)taskDefinition.getConfiguration(), (HierarchicalConfiguration)config);
        }
    }

    @NotNull
    public static List<TaskDefinition> getTaskDefinitionsFromConfig(String taskPrefix, HierarchicalConfiguration fromConfig) {
        ArrayList<TaskDefinition> tasks = new ArrayList<TaskDefinition>();
        List taskConfigs = fromConfig.configurationsAt(taskPrefix + "taskDefinition");
        if (taskConfigs != null) {
            for (Object taskSubNode : taskConfigs) {
                List<TaskConditionConfig> taskConditions;
                SubnodeConfiguration task = (SubnodeConfiguration)taskSubNode;
                long taskId = task.getLong("id");
                String taskPluginKey = task.getString("pluginKey");
                String userDescription = task.getString("userDescription");
                boolean isEnabled = task.getBoolean("isEnabled", true);
                List conditions = task.configurationsAt("conditions.condition");
                if (conditions.isEmpty()) {
                    taskConditions = Collections.emptyList();
                } else {
                    taskConditions = new ArrayList();
                    for (HierarchicalConfiguration condition : conditions) {
                        Map conditionsConfiguration = ConfigUtils.getMapFromConfiguration((String)"config", (String)"item", (HierarchicalConfiguration)condition);
                        taskConditions.add(new TaskConditionConfigImpl(condition.getString("pluginKey"), conditionsConfiguration));
                    }
                }
                boolean finalising = task.getBoolean("finalising", false);
                TaskRootDirectoryType taskRootDirectoryType = TaskRootDirectoryType.valueOf((String)task.getString("rootDirectoryType", TaskRootDirectoryType.INHERITED.toString()));
                long repositoryDefiningWorkingDir = task.getLong("repositoryDefiningWorkingDir", -1L);
                BambooEntityOid oid = Optional.ofNullable(task.getLong("oid", null)).map(BambooEntityOid::create).orElse(null);
                Map taskConfigMap = BambooInterners.intern((Map)ConfigUtils.getMapFromConfiguration((String)"config", (String)"item", (HierarchicalConfiguration)task));
                TaskDefinitionImpl taskDefinition = new TaskDefinitionImpl(taskId, taskPluginKey, userDescription, isEnabled, taskConditions, taskConfigMap, finalising, new TaskRootDirectorySelector(taskRootDirectoryType, repositoryDefiningWorkingDir));
                taskDefinition.setOid(oid);
                tasks.add(taskDefinition);
            }
        }
        return tasks;
    }

    public static long getUniqueId(@NotNull List<TaskDefinition> tasks) {
        long max = 0L;
        for (TaskDefinition definition : tasks) {
            max = Math.max(max, definition.getId());
        }
        return max + 1L;
    }

    @NotNull
    public static List<TaskDefinition> addTaskToList(@NotNull List<TaskDefinition> originalTasks, @NotNull TaskDefinition toAdd) {
        List result = originalTasks.stream().filter(td -> !td.isFinalising()).collect(Collectors.toCollection(LinkedList::new));
        result.add(toAdd);
        originalTasks.stream().filter(TaskIdentifier::isFinalising).forEach(result::add);
        return result;
    }

    public static void adjustFinalisingBar(@NotNull List<TaskDefinition> tasks, long beforeId, long afterId) {
        if (tasks.isEmpty()) {
            return;
        }
        if (beforeId <= 0L) {
            if (tasks.get(0).getId() == afterId) {
                for (TaskDefinition task : tasks) {
                    task.setFinalising(true);
                }
                return;
            }
            log.warn((Object)"Could not move final bar to to beginning of list. task after specified does not match first item in list");
        } else if (afterId <= 0L) {
            if (tasks.get(tasks.size() - 1).getId() == beforeId) {
                for (TaskDefinition task : tasks) {
                    task.setFinalising(false);
                }
                return;
            }
            log.warn((Object)"Could not move final bar to to end of list. task before specified does not match last item in list");
        } else {
            boolean validationPassed = false;
            boolean beforeFound = false;
            ListIterator<TaskDefinition> it = tasks.listIterator();
            while (it.hasNext()) {
                TaskDefinition taskDef = it.next();
                if (beforeId != taskDef.getId()) continue;
                beforeFound = true;
                if (it.hasNext()) {
                    TaskDefinition afterTask = it.next();
                    if (afterTask.getId() == afterId) {
                        validationPassed = true;
                        break;
                    }
                    log.warn((Object)"Could not move final bar. Task After specified does not match next item in list");
                    break;
                }
                log.warn((Object)"Could not move final bar. A task after was specified but there is no next item in the list.");
                break;
            }
            if (!beforeFound) {
                log.warn((Object)"Could not move final bar. Could not find task in list to insert final bar after.");
            }
            if (validationPassed) {
                boolean finalVal = false;
                for (TaskDefinition task : tasks) {
                    task.setFinalising(finalVal);
                    if (beforeId != task.getId()) continue;
                    finalVal = true;
                }
                return;
            }
        }
        throw new IllegalStateException("Could not final bar, task list is out of sync");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static List<TaskDefinition> getNewTaskList(@NotNull List<TaskDefinition> originalTasks, @NotNull TaskDefinition toMove, long beforeId, long afterId, boolean isFinal) {
        if (originalTasks.isEmpty()) {
            return originalTasks;
        }
        LinkedList newTasks = originalTasks.stream().filter(task -> task.getId() != toMove.getId()).collect(Collectors.toCollection(LinkedList::new));
        if (newTasks.isEmpty()) {
            if (beforeId <= 0L && afterId <= 0L) {
                return TaskConfigurationUtils.insertIntoList(newTasks, toMove, 0, isFinal);
            }
            log.warn((Object)"Could not move task. Task list out of sync: task before or task after specified but the list has nothing else in it.");
            throw new IllegalStateException("Could not move tasks, task list is out of sync");
        } else if (beforeId <= 0L) {
            TaskDefinition afterTask = (TaskDefinition)newTasks.getFirst();
            if (afterTask.getId() == afterId) {
                if (!isFinal || afterTask.isFinalising()) return TaskConfigurationUtils.insertIntoList(newTasks, toMove, 0, isFinal);
                log.warn((Object)"Could not move task. Can not move a final task before a non-final task");
                throw new IllegalStateException("Could not move tasks, task list is out of sync");
            } else {
                log.warn((Object)"Could not move task. Task list out of sync: task after specified does not match the next task.");
            }
            throw new IllegalStateException("Could not move tasks, task list is out of sync");
        } else if (afterId <= 0L) {
            TaskDefinition beforeTask = (TaskDefinition)newTasks.getLast();
            if (beforeTask.getId() == beforeId) {
                if (isFinal || !beforeTask.isFinalising()) return TaskConfigurationUtils.insertIntoList(newTasks, toMove, newTasks.size(), isFinal);
                log.warn((Object)"Could not move task. Task list out of sync: can not move a non-final task after a final task");
                throw new IllegalStateException("Could not move tasks, task list is out of sync");
            } else {
                log.warn((Object)"Could not move task. Task list out of sync: task before specified does not match the last task.");
            }
            throw new IllegalStateException("Could not move tasks, task list is out of sync");
        } else {
            ListIterator it = newTasks.listIterator();
            while (it.hasNext()) {
                TaskDefinition beforeTask = (TaskDefinition)it.next();
                if (beforeId != beforeTask.getId()) continue;
                if (it.hasNext()) {
                    TaskDefinition afterTask = (TaskDefinition)it.next();
                    if (afterTask.getId() == afterId) {
                        if (isFinal && afterTask.isFinalising() || !isFinal && !beforeTask.isFinalising()) {
                            return TaskConfigurationUtils.insertIntoList(newTasks, toMove, it.previousIndex(), isFinal);
                        }
                        if (isFinal) {
                            log.warn((Object)"Could not move task. Task list out of sync: can not move final task before a non-final task");
                            break;
                        }
                        log.warn((Object)"Could not move task. Task list out of sync: can not move non-final task before a final task");
                        break;
                    }
                    log.warn((Object)"Could not move task. Task list out of sync: after task specified does not match the next task");
                    break;
                }
                log.warn((Object)"Could not move task. Task list out of sync: after task specified but there are no more tasks in the list");
                break;
            }
            log.warn((Object)"Could not move task. Could not find the task in the list to insert new task after");
        }
        throw new IllegalStateException("Could not move tasks, task list is out of sync");
    }

    private static List<TaskDefinition> insertIntoList(LinkedList<TaskDefinition> list, TaskDefinition task, int index, boolean isFinal) {
        task.setFinalising(isFinal);
        list.add(index, task);
        return list;
    }

    @Nullable
    public static BambooEntityOid getMaxTaskOid(int serverKey) {
        try (Ticker ignored = Timers.start((String)(TaskConfigurationUtils.class.getName() + ".maxTaskOid"));){
            BambooEntityOid bambooEntityOid = ((CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get()).getPlansUnrestricted().stream().map(ImmutableChain::getAllJobs).flatMap(Collection::stream).map(TaskContainer::getTaskDefinitions).flatMap(Collection::stream).map(ImmutableEntityWithOid::getOid).filter(oid -> oid.getServerKey() == serverKey).max(Comparator.comparing(BambooEntityOid::getEntityOid, Long::compare)).orElse(null);
            return bambooEntityOid;
        }
    }

    @NotNull
    public static Optional<List<TaskDefinition>> replaceCapabilityLabelInTasks(@NotNull List<TaskDefinition> taskDefinitions, @NotNull String keyToReplace, @NotNull String oldCapabilityLabel, @NotNull String newCapabilityLabel, @NotNull String oldCapabilityKey, @NotNull String newCapabilityKey) {
        boolean requiresUpdate = false;
        for (TaskDefinition taskDefinition : taskDefinitions) {
            HashMap<String, String> taskConfiguration = new HashMap<String, String>(taskDefinition.getConfiguration());
            String currentLabel = (String)taskConfiguration.get(keyToReplace);
            if (StringUtils.equals((CharSequence)currentLabel, (CharSequence)oldCapabilityLabel)) {
                taskConfiguration.put(keyToReplace, newCapabilityLabel);
                taskDefinition.setConfiguration(taskConfiguration);
                requiresUpdate = true;
                continue;
            }
            if (!StringUtils.equals((CharSequence)currentLabel, (CharSequence)oldCapabilityKey)) continue;
            taskConfiguration.put(keyToReplace, newCapabilityKey);
            taskDefinition.setConfiguration(taskConfiguration);
            requiresUpdate = true;
        }
        return requiresUpdate ? Optional.of(taskDefinitions) : Optional.empty();
    }
}

