/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fileserver;

import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.configuration.DefaultContentHandler;
import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementContentElementParser;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MimeTypeLoader
extends DefaultContentHandler {
    private static final String CHARSET = ";charset=";
    private Map<String, String> myMimeTypes;
    private String myExtension;
    private String myMimeType;

    public MimeTypeLoader() {
        this.registerElementParser("mime-types", new DefaultElementParser());
        this.registerElementParser("mime-mapping", new MimeMappingElementParser());
        this.registerElementParser("extension", new ExtensionElementParser());
        this.registerElementParser("mime-type", new MimeTypeElementParser());
    }

    public void loadConfiguration(InputStream configurationFile) throws ConfigurationException {
        try {
            XMLReader reader = SecureXmlParserFactory.newNamespaceAwareXmlReader();
            this.myMimeTypes = new HashMap<String, String>();
            reader.setContentHandler(this);
            reader.parse(new InputSource(configurationFile));
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to parse configuration file", (Throwable)e);
        }
    }

    public Map<String, String> getMimeTypes() {
        return this.myMimeTypes;
    }

    public class MimeTypeElementParser
    extends ElementContentElementParser {
        @Override
        public void endElement() {
            MimeTypeLoader.this.myMimeType = this.getElementContent();
        }
    }

    public class ExtensionElementParser
    extends ElementContentElementParser {
        @Override
        public void endElement() {
            MimeTypeLoader.this.myExtension = this.getElementContent();
        }
    }

    public class MimeMappingElementParser
    extends DefaultElementParser {
        @Override
        public void startElement(Attributes attributes) {
            MimeTypeLoader.this.myExtension = null;
            MimeTypeLoader.this.myMimeType = null;
        }

        @Override
        public void endElement() {
            if ("text/plain".equals(MimeTypeLoader.this.myMimeType) && !MimeTypeLoader.this.myMimeType.contains(MimeTypeLoader.CHARSET)) {
                MimeTypeLoader.this.myMimeTypes.put(MimeTypeLoader.this.myExtension, MimeTypeLoader.this.myMimeType + MimeTypeLoader.CHARSET + SystemProperty.TEXT_PLAIN_MIME_DEFAULT_ENCODING.getValue("UTF-8"));
            } else {
                MimeTypeLoader.this.myMimeTypes.put(MimeTypeLoader.this.myExtension, MimeTypeLoader.this.myMimeType);
            }
        }
    }
}

