/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fileserver;

import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class StorageTagUtils {
    public static final Map<PlanKey, ChainStorageTag> gatherNeededStorageTags(StorageTagService storageTagService, List<TaskDefinition> taskDefinitions, @Nullable BuildIdentifier identifier) {
        Set planKeys = taskDefinitions.stream().filter(BambooPluginUtils.pluginKeyEquals("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask")).map(TaskDefinition::getConfiguration).map(ArtifactDownloaderTaskConfigurationHelper::getSourcePlanKey).map(PlanKeys::getPlanKey).collect(Collectors.toCollection(HashSet::new));
        if (identifier != null && identifier.getTypedPlanKey() != null && PlanKeys.isJobKey((PlanKey)identifier.getTypedPlanKey())) {
            planKeys.add(PlanKeys.getChainKeyFromJobKey((PlanKey)identifier.getTypedPlanKey()));
        }
        ImmutableMap.Builder neededStorageTags = ImmutableMap.builder();
        for (PlanKey planKey : planKeys) {
            ChainStorageTag storageTag = storageTagService.getChainStorageTag(planKey);
            if (storageTag == null) continue;
            neededStorageTags.put((Object)planKey, (Object)storageTag);
        }
        return neededStorageTags.build();
    }
}

