/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.fileserver;

import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class SystemDirectory {
    private static final String LOGS_DIRECTORY = "logs";
    private static final String SERVER_STATE_SUB_DIR = "serverState";
    private static final String AGENT_STATE_SUB_DIR = "agentState";
    private static final String CFG_EXPORTS_DIR = "cfg-exports";

    private SystemDirectory() {
    }

    public static File getApplicationHome() {
        return SystemDirectory.getApplicationHomePath().toFile();
    }

    private static Path getApplicationHomePath() {
        AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        return Paths.get(bootstrapManager.getApplicationHome(), new String[0]);
    }

    public static File getConfigDirectory() {
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        return new File(bootstrapManager.getConfigDirectory());
    }

    public static String getLogRelativePath(@NotNull String file) {
        return LOGS_DIRECTORY + File.separator + file;
    }

    public static File getBambooLogsDirectory() {
        return new File(SystemDirectory.getApplicationHome(), LOGS_DIRECTORY);
    }

    public static File getPluginDirectory() {
        return SystemDirectory.getExistingDirectory(SystemDirectory.getApplicationHomePath().resolve("plugins"));
    }

    public static File getCacheDirectory() {
        return SystemDirectory.getExistingDirectory(SystemDirectory.getCacheDirectoryPath());
    }

    private static Path getCacheDirectoryPath() {
        return SystemDirectory.getApplicationHomePath().resolve("caches");
    }

    public static File getServerStateDirectory() {
        return SystemDirectory.getExistingDirectory(SystemDirectory.getApplicationHomePath().resolve(SERVER_STATE_SUB_DIR));
    }

    public static File getConfigurationExportsDirectory() {
        return SystemDirectory.getExistingDirectory(SystemDirectory.getApplicationHomePath().resolve(CFG_EXPORTS_DIR));
    }

    public static File getAgentStateDirectory() {
        return SystemDirectory.getExistingDirectory(SystemDirectory.getApplicationHomePath().resolve(AGENT_STATE_SUB_DIR));
    }

    public static File getPluginCacheDirectory() {
        return SystemDirectory.getExistingDirectory(SystemDirectory.getCacheDirectoryPath().resolve("plugins"));
    }

    public static File getBaseBuildWorkingDirectory() {
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        return new File(bootstrapManager.getBuildWorkingDirectory());
    }

    private static File getExistingDirectory(Path path) {
        File directory = path.toFile();
        BambooFileUtils.createDirectoryIfNotExists(directory);
        return directory;
    }
}

