/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.health;

import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.bamboo.health.MySQLChecks;
import com.atlassian.bamboo.health.MySQLChecksImpl;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.config.db.HibernateConfig;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class BambooHealthCheckServiceImpl
implements BambooHealthCheckService {
    private final HibernateConfig hibernateConfig;
    private final DbmsBean dbmsBean;
    private final AgentManager agentManager;
    private final HibernateTemplate hibernateTemplate;
    private final Set<String> pluginsThatCanBeDisabled = new HashSet<String>();
    private final Set<String> modulesThatCanBeDisabled = new HashSet<String>();

    @Inject
    public BambooHealthCheckServiceImpl(HibernateConfig hibernateConfig, DbmsBean dbmsBean, AgentManager agentManager, HibernateTemplate hibernateTemplate) {
        this.hibernateConfig = hibernateConfig;
        this.dbmsBean = dbmsBean;
        this.agentManager = agentManager;
        this.hibernateTemplate = hibernateTemplate;
    }

    public DatabaseType getDatabaseType() {
        return this.dbmsBean.getDatabaseType();
    }

    public int getMaxDbConnectionPoolsSize() {
        return BambooHibernateUtils.getMaxConnectionPoolSize(this.hibernateConfig);
    }

    public long getLocalAgentsCount() {
        return this.agentManager.getAgentCount(LocalAgentDefinition.class);
    }

    public void ignoreDisabledPlugin(String key) {
        this.pluginsThatCanBeDisabled.add(key);
    }

    public void ignoreDisabledPluginModule(String completeKey) {
        this.modulesThatCanBeDisabled.add(completeKey);
    }

    public Set<String> getPluginsThatCanBeDisabled() {
        return this.pluginsThatCanBeDisabled;
    }

    public Set<String> getModulesThatCanBeDisabled() {
        return this.modulesThatCanBeDisabled;
    }

    public MySQLChecks getMySQLChecks() {
        return new MySQLChecksImpl(this.hibernateTemplate);
    }
}

