/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.health;

import com.atlassian.bamboo.health.MySQLChecks;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class MySQLChecksImpl
implements MySQLChecks {
    private static final Logger log = Logger.getLogger(MySQLChecksImpl.class);
    private static final String DB_NAME_QUERY = "SELECT DATABASE() FROM DUAL;";
    private static final String DATABASE_CHARACTER_SET_QUERY = "SELECT DEFAULT_CHARACTER_SET_NAME FROM information_schema.SCHEMATA S WHERE schema_name = ? AND DEFAULT_CHARACTER_SET_NAME != 'utf8';";
    private static final String TABLE_CHARACTER_SET_QUERY = "SELECT CCSA.character_set_name FROM information_schema.`TABLES` T,  information_schema.`COLLATION_CHARACTER_SET_APPLICABILITY` CCSA  WHERE CCSA.collation_name = T.table_collation  AND T.table_schema = ? AND character_set_name != 'utf8';";
    private static final String COLUMN_CHARACTER_SET_QUERY = "SELECT TABLE_NAME, COLUMN_NAME, CHARACTER_SET_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND CHARACTER_SET_NAME != 'utf8';";
    private static final String DATABASE_COLLATION_QUERY = "SELECT DEFAULT_COLLATION_NAME FROM information_schema.SCHEMATA S WHERE schema_name = ? AND DEFAULT_COLLATION_NAME != 'utf8_bin';";
    private static final String TABLE_COLLATION_QUERY = "SELECT T.TABLE_NAME, C.COLLATION_NAME FROM information_schema.TABLES AS T, information_schema.`COLLATION_CHARACTER_SET_APPLICABILITY` AS C WHERE C.collation_name = T.table_collation AND T.table_schema = ? AND C.COLLATION_NAME != 'utf8_bin';";
    private static final String COLUMN_COLLATION_QUERY = "SELECT TABLE_NAME, COLUMN_NAME, COLLATION_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND COLLATION_NAME != 'utf8_bin';";
    private static final String TEST_TABLE_NAME = "supporthealthchecks";
    private static final String MAX_PACKETS_QUERY = "show session variables like 'max_allowed_packet';";
    private static final String LOG_FILE_SIZE_QUERY = "show session variables like 'innodb_log_file_size';";
    private static final long INNODB_LOG_FILE_SIZE_RECOMMENDED = 0x4000000L;
    private static final long MAX_PACKETS_RECOMMENDED = 0x1000000L;
    private final HibernateTemplate hibernateTemplate;

    public MySQLChecksImpl(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public boolean isMaxAllowedPacketSizeCheckPass() throws IllegalStateException {
        long maxPackets = this.getMaxAllowedPacketSize();
        return maxPackets >= this.getRecommendedMaxPacketsSize();
    }

    public long getMaxAllowedPacketSize() {
        log.debug((Object)"Fetch max allowed packet size");
        return this.fetchSingleValue(MAX_PACKETS_QUERY);
    }

    public long getRecommendedMaxPacketsSize() {
        return 0x1000000L;
    }

    public boolean isCharacterSetCheckPass() {
        log.debug((Object)"Validate character check");
        return this.checkIfResultsAreEmpty(Arrays.asList(DATABASE_CHARACTER_SET_QUERY, TABLE_CHARACTER_SET_QUERY, COLUMN_CHARACTER_SET_QUERY));
    }

    public boolean isCollationCheckPass() {
        log.debug((Object)"Validate collation check");
        return this.checkIfResultsAreEmpty(Arrays.asList(DATABASE_COLLATION_QUERY, TABLE_COLLATION_QUERY, COLUMN_COLLATION_QUERY));
    }

    public boolean isInnoDBLogFileSizeCheckPass() {
        return this.getInnoDBLogFileSize() >= 0x4000000L;
    }

    public long getInnoDBLogFileSize() {
        log.debug((Object)"Fetch InnoDB log file size");
        return this.fetchSingleValue(LOG_FILE_SIZE_QUERY);
    }

    public long getRecommendedInnoDBLogFileSize() {
        return 0x4000000L;
    }

    private boolean checkIfResultsAreEmpty(List<String> queries) {
        return (Boolean)this.hibernateTemplate.execute(session -> (Boolean)session.doReturningWork(connection -> this.checkIfResultsAreEmpty(queries, connection)));
    }

    private boolean checkIfResultsAreEmpty(List<String> queries, Connection connection) {
        try {
            this.createTable(connection, TEST_TABLE_NAME);
            String databaseName = this.getDatabaseName(connection);
            Preconditions.checkState((databaseName != null ? 1 : 0) != 0, (Object)"Can't read DB name");
            for (String query : queries) {
                PreparedStatement statement = connection.prepareStatement(query);
                Throwable throwable = null;
                try {
                    statement.setString(1, databaseName);
                    ResultSet resultSet = statement.executeQuery();
                    if (!resultSet.next()) continue;
                    this.printWarning(query, resultSet);
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            try {
                this.dropTable(connection, TEST_TABLE_NAME);
            }
            catch (SQLException | HibernateException e) {
                log.error((Object)e.getMessage(), e);
            }
        }
    }

    private void printWarning(String query, ResultSet resultSet) throws SQLException {
        log.warn((Object)("query - " + query));
        int columnCount = resultSet.getMetaData().getColumnCount();
        do {
            StringBuilder buffer = new StringBuilder();
            for (int i = 1; i <= columnCount; ++i) {
                buffer.append(resultSet.getString(i)).append(" | ");
            }
            log.warn((Object)("found unexpected result: " + buffer.toString()));
        } while (resultSet.next());
    }

    @Nullable
    private String getDatabaseName(@NotNull Connection connection) throws SQLException, HibernateException {
        return MySQLChecksImpl.executeQuery(connection, DB_NAME_QUERY);
    }

    private static boolean execute(@NotNull Connection connection, @NotNull String query) throws SQLException, HibernateException {
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.execute(query);
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static String executeQuery(@NotNull Connection connection, String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static String executeQuery(@NotNull Connection connection, String query, String columnName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createTable(@NotNull Connection connection, @NotNull String tableName) throws SQLException, HibernateException {
        String query = String.format("CREATE TABLE IF NOT EXISTS `%s.%s` (id VARCHAR(45));", this.getDatabaseName(connection), tableName);
        MySQLChecksImpl.execute(connection, query);
    }

    private void dropTable(@NotNull Connection connection, @NotNull String tableName) throws SQLException, HibernateException {
        String query = String.format("DROP TABLE IF EXISTS `%s.%s`;", this.getDatabaseName(connection), tableName);
        MySQLChecksImpl.execute(connection, query);
    }

    private long fetchSingleValue(String sql) throws IllegalStateException {
        String result = (String)this.hibernateTemplate.execute(session -> (String)session.doReturningWork(connection -> {
            try {
                return MySQLChecksImpl.executeQuery(connection, sql, "Value");
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }));
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)("Can't get result from DB for " + sql));
        return Long.valueOf(result);
    }
}

