/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.index.AbstractDocumentHitCollector;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocumentFactory;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;

public class FindLatestBuildResultHitCollector
extends AbstractDocumentHitCollector {
    private final BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory;
    private ResultsSummary buildResultsSummary;

    public FindLatestBuildResultHitCollector(BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory) {
        this.buildResultsSummaryDocumentFactory = buildResultsSummaryDocumentFactory;
    }

    protected void collect(@NotNull Document document) {
        if (this.buildResultsSummary == null) {
            this.buildResultsSummary = this.buildResultsSummaryDocumentFactory.getBuildResultsSummary(document);
        } else {
            int buildNumber = BuildResultsSummaryDocument.FIELD_BUILD_NUMBER.getValue(document, 0);
            if (buildNumber > this.buildResultsSummary.getBuildNumber()) {
                this.buildResultsSummary = this.buildResultsSummaryDocumentFactory.getBuildResultsSummary(document);
            }
        }
    }

    public ResultsSummary getBuildResultsSummary() {
        return this.buildResultsSummary;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

