/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.util.NumberUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexUtils {
    private static final Logger log = Logger.getLogger(IndexUtils.class);

    private IndexUtils() {
    }

    @Deprecated
    public static void addFieldId(@NotNull String fieldId, long value, @NotNull Document document) {
        IndexUtils.addField(fieldId, Long.toString(value), document);
    }

    public static void addTypedField(@NotNull String name, int value, @NotNull Document doc) {
        doc.add((IndexableField)new IntField(name, value, Field.Store.YES));
    }

    public static int getIntField(Document document, String fieldId) {
        return IndexUtils.getNumericValue(document.getField(fieldId)).intValue();
    }

    public static void addTypedField(@NotNull String name, long value, @NotNull Document doc) {
        doc.add((IndexableField)new LongField(name, value, Field.Store.YES));
    }

    public static long getLongField(Document document, String fieldId) {
        return IndexUtils.getNumericValue(document.getField(fieldId)).longValue();
    }

    public static void addTypedField(@NotNull String name, double value, @NotNull Document doc) {
        doc.add((IndexableField)new DoubleField(name, value, Field.Store.YES));
    }

    public static double getDoubleField(Document document, String fieldId) {
        return IndexUtils.getNumericValue(document.getField(fieldId)).doubleValue();
    }

    @Nullable
    public static Double getOptionalDoubleField(Document document, String fieldId) {
        IndexableField field = document.getField(fieldId);
        if (field == null) {
            return null;
        }
        return field.numericValue().doubleValue();
    }

    public static void addTypedField(@NotNull String name, float value, @NotNull Document doc) {
        doc.add((IndexableField)new FloatField(name, value, Field.Store.YES));
    }

    public static void addField(@NotNull String fieldId, @Nullable String fieldValue, @NotNull Document document) {
        if (fieldValue != null) {
            document.add((IndexableField)new StringField(fieldId, fieldValue, Field.Store.YES));
        } else {
            log.debug((Object)("Field " + fieldId + " not indexed as value is null."));
        }
    }

    public static void addField(@NotNull String fieldId, @Nullable Number fieldValue, @NotNull Document document) {
        if (fieldValue != null) {
            IndexUtils.addField(fieldId, NumberUtils.padWithZeroes((Number)fieldValue, (int)12), document);
        } else {
            log.debug((Object)("Field " + fieldId + " not indexed as value is null."));
        }
    }

    @Deprecated
    public static void addField(@NotNull String fieldId, @Nullable Date fieldValue, @NotNull Document document) {
        if (fieldValue != null) {
            IndexUtils.addField(fieldId, DateTools.dateToString((Date)fieldValue, (DateTools.Resolution)DateTools.Resolution.SECOND), document);
        } else {
            log.debug((Object)("Field " + fieldId + " not indexed as value is null."));
        }
    }

    public static void addTypedField(@NotNull String name, @Nullable Date date, @NotNull Document document) {
        if (date != null) {
            IndexUtils.addTypedField(name, date.getTime(), document);
        } else {
            log.debug((Object)("Field " + name + " not indexed as value is null."));
        }
    }

    @Nullable
    public static Date getDateField(@NotNull Document document, @NotNull String fieldId) {
        IndexableField field = document.getField(fieldId);
        return field != null ? new Date(IndexUtils.getNumericValue(field).longValue()) : null;
    }

    @NotNull
    private static Number getNumericValue(IndexableField field) {
        return (Number)Preconditions.checkNotNull((Object)field.numericValue(), (Object)("Field " + field.name() + " is not a numeric field"));
    }

    public static long getFieldId(@NotNull Document document, @NotNull String fieldId) {
        String stringId = document.get(fieldId);
        try {
            if (StringUtils.isNotBlank((CharSequence)stringId)) {
                return NumberUtils.stringToLong((String)stringId);
            }
        }
        catch (Exception e) {
            log.warn((Object)("unable to parse id field.  returning -1. Field: " + fieldId + " value: " + stringId));
        }
        return -1L;
    }

    @NotNull
    public static BooleanQuery buildConjunctionQuery(Query ... queries) {
        BooleanQuery combinedQ = new BooleanQuery();
        for (Query query : queries) {
            combinedQ.add(query, BooleanClause.Occur.MUST);
        }
        return combinedQ;
    }

    @NotNull
    public static BooleanQuery buildConjunctionQuery(Iterable<? extends Query> queries) {
        BooleanQuery q = new BooleanQuery();
        for (Query query : queries) {
            q.add(query, BooleanClause.Occur.MUST);
        }
        return q;
    }
}

