/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.index.IndexerContext;
import com.atlassian.bamboo.index.IndexerContextImpl;
import com.atlassian.bonnie.ILuceneConnection;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IndexerContextBuilder {
    private static final Logger log = Logger.getLogger(IndexerContextBuilder.class);
    private final ILuceneConnection connection;
    private final AtomicBoolean indexerLockStatus;
    private final ListeningExecutorService executorService;
    private boolean canReadWhenLocked;
    private boolean canWriteWhenLocked;

    public IndexerContextBuilder(@NotNull ILuceneConnection connection, @NotNull AtomicBoolean indexerLockStatus, @NotNull ListeningExecutorService executorService) {
        this.connection = connection;
        this.indexerLockStatus = indexerLockStatus;
        this.executorService = executorService;
    }

    public IndexerContextBuilder canReadWhenLocked() {
        this.canReadWhenLocked = true;
        return this;
    }

    public IndexerContextBuilder canReadAndWriteWhenLocked() {
        this.canReadWhenLocked = true;
        this.canWriteWhenLocked = true;
        return this;
    }

    public IndexerContext build() {
        return new IndexerContextImpl(this.connection, this.indexerLockStatus, this.executorService, this.canReadWhenLocked, this.canWriteWhenLocked);
    }
}

