/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.index.IndexerManager;
import com.atlassian.event.api.EventListener;
import org.apache.log4j.Logger;

public class IndexerEventListener {
    private static final Logger log = Logger.getLogger(IndexerEventListener.class);
    private final IndexerManager indexerManager;

    public IndexerEventListener(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }

    @EventListener
    public void onServerStarted(ServerStartedEvent event) {
        if (this.indexerManager.isPendingFullReindex()) {
            log.info((Object)"Running scheduled full reindex on Bamboo restart");
            this.indexerManager.triggerFullReindex();
        } else if (this.indexerManager.isPendingPartialReindex()) {
            log.info((Object)"Running scheduled partial reindex on Bamboo restart.");
            this.indexerManager.triggerPartialReindex();
        }
    }
}

