/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.index.Indexer;
import com.atlassian.bamboo.index.IndexerManager;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.HibernateConfig;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.springframework.beans.factory.DisposableBean;

public class IndexerManagerImpl
implements IndexerManager,
DisposableBean {
    private static final Logger log = Logger.getLogger(IndexerManagerImpl.class);
    private static final String CFG_PENDING_FULL_REINDEX = "bamboo.indexerManager.pendingFullReindex";
    private static final String CFG_PENDING_PARTIAL_REINDEX = "bamboo.indexerManager.pendingPartialReindex";
    private static final String CFG_PENDING_PARTIAL_REINDEXERS = "bamboo.indexerManager.pendingPartialReindex.indexers";
    private static final String CFG_FULL_REINDEX_IN_PROGRESS = "bamboo.indexerManager.fullReindexInProgress";
    private final List<Indexer> indexers;
    private final AtomicBoolean reindexInProgress = new AtomicBoolean(false);
    private final ListeningExecutorService reindexAllControllerExecutorService;
    private Date fullReindexEstimatedCompletionTime;
    private final ApplicationConfiguration applicationConfig;
    private final HibernateConfig hibernateConfig;
    private final AtomicBoolean indexingPauseRequested = new AtomicBoolean(false);
    private final AtomicReference<ListenableFuture<Boolean>> lastReindexResult = new AtomicReference<ListenableFuture>(Futures.immediateFuture((Object)false));

    public IndexerManagerImpl(@NotNull ApplicationConfiguration applicationConfig, @NotNull HibernateConfig hibernateConfig, @NotNull List<Indexer> indexers) {
        this.applicationConfig = applicationConfig;
        this.hibernateConfig = hibernateConfig;
        this.indexers = indexers;
        this.reindexAllControllerExecutorService = SystemSecurityContextExecutors.newSingleThreadExecutor("IndexerManager.reindexAllController");
    }

    @NotNull
    public ListenableFuture<Boolean> triggerFullReindex() {
        return this.triggerReindex(this.indexers);
    }

    @NotNull
    public ListenableFuture<Boolean> triggerPartialReindex() {
        return this.triggerReindex(this.getPendingIndexers());
    }

    public void destroy() {
        this.reindexAllControllerExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Boolean> triggerReindex(final @NotNull List<Indexer> requestedIndexers) {
        if (this.reindexInProgress.compareAndSet(false, true)) {
            final SettableFuture resultFuture = SettableFuture.create();
            AtomicBoolean atomicBoolean = this.indexingPauseRequested;
            synchronized (atomicBoolean) {
                if (this.indexingPauseRequested.get()) {
                    this.reindexInProgress.set(false);
                    return this.lastReindexResult.get();
                }
                this.lastReindexResult.set((ListenableFuture<Boolean>)resultFuture);
            }
            final AtomicBoolean clearScheduledReindexOnRestartFlag = new AtomicBoolean(false);
            final AtomicBoolean clearScheduledPendingReindexOnRestartFlag = new AtomicBoolean(false);
            this.fullReindexEstimatedCompletionTime = new DateTime().plus((ReadablePeriod)Period.seconds((int)((int)this.getEstimatedReindexTime()))).toDate();
            ListenableFuture future = this.reindexAllControllerExecutorService.submit((Callable)new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    log.info((Object)"Starting full re-index");
                    ListeningExecutorService reindexAllWorkerExecutorService = IndexerManagerImpl.this.createReindexExecutor();
                    IndexerManagerImpl.this.markStartedFullReindex();
                    clearScheduledReindexOnRestartFlag.set(IndexerManagerImpl.this.isPendingFullReindex());
                    clearScheduledPendingReindexOnRestartFlag.set(IndexerManagerImpl.this.isPendingPartialReindex());
                    Stopwatch stopWatch = Stopwatch.createStarted();
                    try {
                        IndexerManagerImpl.this.removeIndexes(requestedIndexers);
                        try {
                            for (Indexer indexer : requestedIndexers) {
                                indexer.indexAll((Executor)reindexAllWorkerExecutorService);
                            }
                            reindexAllWorkerExecutorService.shutdown();
                            reindexAllWorkerExecutorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                        }
                        finally {
                            reindexAllWorkerExecutorService.shutdownNow();
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    finally {
                        log.info((Object)("Completed full reindex. Took: " + stopWatch));
                    }
                }
            });
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Boolean>(){

                public void onSuccess(@NotNull Boolean result) {
                    if (result.booleanValue()) {
                        if (clearScheduledReindexOnRestartFlag.get()) {
                            IndexerManagerImpl.this.clearPendingReindex();
                        }
                        if (clearScheduledPendingReindexOnRestartFlag.get()) {
                            IndexerManagerImpl.this.clearPendingPartialReindex();
                        }
                        IndexerManagerImpl.this.markCompletedFullReindex();
                    } else {
                        log.warn((Object)"Full reindex didn't complete successfully.");
                        IndexerManagerImpl.this.setPendingFullReindex();
                    }
                    IndexerManagerImpl.this.fullReindexEstimatedCompletionTime = null;
                    IndexerManagerImpl.this.reindexInProgress.set(false);
                    resultFuture.set((Object)result);
                }

                public void onFailure(@NotNull Throwable t) {
                    log.warn((Object)"Error while performing full reindex", t);
                    IndexerManagerImpl.this.setPendingFullReindex();
                    IndexerManagerImpl.this.fullReindexEstimatedCompletionTime = null;
                    IndexerManagerImpl.this.reindexInProgress.set(false);
                    resultFuture.set((Object)false);
                }
            });
            return resultFuture;
        }
        log.info((Object)"Reindex operation is already running");
        return Futures.immediateFuture((Object)false);
    }

    public long getEstimatedReindexTime() {
        long estimatedReindexTime = 0L;
        for (Indexer indexer : this.indexers) {
            estimatedReindexTime += indexer.getEstimatedReindexTime();
        }
        return estimatedReindexTime;
    }

    public int getNumberOfDocuments() {
        int documentsNumber = 0;
        for (Indexer indexer : this.indexers) {
            documentsNumber += indexer.getNumberOfDocuments();
        }
        return documentsNumber;
    }

    public boolean isReindexInProgress() {
        return this.reindexInProgress.get();
    }

    public void setPendingFullReindex() {
        try {
            this.applicationConfig.setProperty((Object)CFG_PENDING_FULL_REINDEX, true);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Couldn't update configuration - pending full reindex request was not scheduled", (Throwable)e);
        }
    }

    public boolean isPendingFullReindex() {
        return this.applicationConfig.getBooleanProperty((Object)CFG_PENDING_FULL_REINDEX) || !this.reindexInProgress.get() && this.applicationConfig.getBooleanProperty((Object)CFG_FULL_REINDEX_IN_PROGRESS);
    }

    public Date getEstimatedReindexCompletionTime() {
        return this.fullReindexEstimatedCompletionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Boolean> pauseIndexing() {
        AtomicBoolean atomicBoolean = this.indexingPauseRequested;
        synchronized (atomicBoolean) {
            this.indexingPauseRequested.set(true);
            return this.lastReindexResult.get();
        }
    }

    public boolean isPendingPartialReindex() {
        return this.applicationConfig.getBooleanProperty((Object)CFG_PENDING_PARTIAL_REINDEX) || !this.reindexInProgress.get() && this.applicationConfig.getBooleanProperty((Object)CFG_FULL_REINDEX_IN_PROGRESS);
    }

    public void setPendingPartialReindex(List<String> indexerNames) {
        try {
            this.applicationConfig.setProperty((Object)CFG_PENDING_PARTIAL_REINDEX, true);
            this.applicationConfig.setProperty((Object)CFG_PENDING_PARTIAL_REINDEXERS, (Object)StringUtils.join(indexerNames, (String)","));
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Couldn't update configuration - pending partial reindex request was not scheduled", (Throwable)e);
        }
    }

    @NotNull
    protected List<Indexer> getPendingIndexers() {
        if (this.applicationConfig.getBooleanProperty((Object)CFG_PENDING_FULL_REINDEX)) {
            return this.indexers;
        }
        if (this.applicationConfig.getBooleanProperty((Object)CFG_PENDING_PARTIAL_REINDEX)) {
            String indexersString = (String)this.applicationConfig.getProperty((Object)CFG_PENDING_PARTIAL_REINDEXERS);
            log.info((Object)("Partial set of indexers requested for reindex: " + indexersString));
            ArrayList requestedIndexerNames = Lists.newArrayList((Object[])StringUtils.split((String)indexersString, (String)","));
            ArrayList<Indexer> requestedIndexers = new ArrayList<Indexer>();
            for (Indexer indexer : this.indexers) {
                if (!requestedIndexerNames.contains(indexer.getClass().getSimpleName())) continue;
                requestedIndexers.add(indexer);
                requestedIndexerNames.remove(indexer.getClass().getSimpleName());
            }
            if (!requestedIndexerNames.isEmpty()) {
                log.warn((Object)("Not all requested indexes could be reindexed. The following were indexers were not found: " + StringUtils.join((Iterable)requestedIndexerNames, (String)",")));
            }
            return requestedIndexers;
        }
        if (!this.reindexInProgress.get() && this.applicationConfig.getBooleanProperty((Object)CFG_FULL_REINDEX_IN_PROGRESS)) {
            return this.indexers;
        }
        return new ArrayList<Indexer>();
    }

    private void clearPendingReindex() {
        try {
            this.applicationConfig.removeProperty((Object)CFG_PENDING_FULL_REINDEX);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Couldn't update configuration - pending full reindex request was not cleared", (Throwable)e);
        }
    }

    private void clearPendingPartialReindex() {
        try {
            this.applicationConfig.removeProperty((Object)CFG_PENDING_PARTIAL_REINDEX);
            this.applicationConfig.removeProperty((Object)CFG_PENDING_PARTIAL_REINDEXERS);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Couldn't update configuration - pending full reindex request was not cleared", (Throwable)e);
        }
    }

    private void markStartedFullReindex() {
        try {
            this.applicationConfig.setProperty((Object)CFG_FULL_REINDEX_IN_PROGRESS, true);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.warn((Object)String.format("Couldn't update configuration - %s property was not updated", CFG_FULL_REINDEX_IN_PROGRESS), (Throwable)e);
        }
    }

    private void markCompletedFullReindex() {
        try {
            this.applicationConfig.removeProperty((Object)CFG_FULL_REINDEX_IN_PROGRESS);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.warn((Object)String.format("Couldn't update configuration - %s property was not removed", CFG_FULL_REINDEX_IN_PROGRESS), (Throwable)e);
        }
    }

    private void removeIndexes(@NotNull List<Indexer> requestedIndexers) {
        for (Indexer indexer : requestedIndexers) {
            indexer.deleteIndex();
        }
    }

    private ListeningExecutorService createReindexExecutor() {
        int maxDbConnections = BambooHibernateUtils.getMaxConnectionPoolSize(this.hibernateConfig);
        int maxThreads = Math.max(Runtime.getRuntime().availableProcessors() / 4, 1);
        int nThreads = Math.min(maxDbConnections, maxThreads);
        log.debug((Object)String.format("Creating reindex executor with thread pool size of %d", nThreads));
        return SystemSecurityContextExecutors.newThreadPool(nThreads, "IndexerManager.reindexAllWorker");
    }
}

