/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.index.IndexSearcherTask;
import com.atlassian.bamboo.index.IndexerContext;
import com.atlassian.bamboo.index.IndexerContextBuilder;
import com.atlassian.bamboo.index.IndexerService;
import com.atlassian.bamboo.index.IndexerTask;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.utils.concurrent.BambooLocks;
import com.atlassian.bonnie.ILuceneConnection;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;

public class IndexerServiceImpl
implements IndexerService,
DisposableBean {
    private static final Logger log = Logger.getLogger(IndexerServiceImpl.class);
    private static final int MAX_QUEUE_SIZE_PER_CONNECTION = 100;
    private static final int MAX_QUERY_HITS = 10000;
    private final LoadingCache<ILuceneConnection, ListeningExecutorService> executorServiceCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ILuceneConnection, ListeningExecutorService>(){

        public ListeningExecutorService load(ILuceneConnection key) throws Exception {
            return SystemSecurityContextExecutors.newSingleThreadExecutor(100, "IndexerService.indexer");
        }
    });
    private final LoadingCache<Object, ReentrantLock> queueOperationsLockCache = BambooLocks.weakReentrantLockFactory();
    private final LoadingCache<ILuceneConnection, AtomicBoolean> indexerLockStatusCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ILuceneConnection, AtomicBoolean>(){

        public AtomicBoolean load(ILuceneConnection key) throws Exception {
            return new AtomicBoolean(false);
        }
    });
    private final LoadingCache<ILuceneConnection, ConcurrentLinkedQueue<ListenableFutureTask>> indexerQueueCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ILuceneConnection, ConcurrentLinkedQueue<ListenableFutureTask>>(){

        public ConcurrentLinkedQueue<ListenableFutureTask> load(ILuceneConnection key) throws Exception {
            return new ConcurrentLinkedQueue<ListenableFutureTask>();
        }
    });

    public void destroy() {
        for (ListeningExecutorService service : this.executorServiceCache.asMap().values()) {
            service.shutdown();
        }
    }

    @NotNull
    public IndexerContext createNewIndexerContext(@NotNull ILuceneConnection connection) {
        try {
            return new IndexerContextBuilder(connection, (AtomicBoolean)this.indexerLockStatusCache.getUnchecked((Object)connection), (ListeningExecutorService)this.executorServiceCache.get((Object)connection)).canReadWhenLocked().build();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(String.format("Couldn't create ExecutorService for LuceneConnection %s", connection));
        }
    }

    @NotNull
    public IndexerContext lockIndexerQueue(@NotNull ILuceneConnection connection) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Locking indexer for connection %s", connection.toString()));
        }
        ReentrantLock lock = this.getQueueOperationsLock(connection);
        lock.lock();
        try {
            AtomicBoolean indexerLockStatus = (AtomicBoolean)this.indexerLockStatusCache.getUnchecked((Object)connection);
            if (indexerLockStatus.compareAndSet(false, true)) {
                IndexerContext indexerContext = new IndexerContextBuilder(connection, indexerLockStatus, (ListeningExecutorService)this.executorServiceCache.get((Object)connection)).canReadAndWriteWhenLocked().build();
                return indexerContext;
            }
            try {
                throw new IllegalStateException(String.format("Queue for connection %s is already locked", connection));
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(String.format("Couldn't create ExecutorService for LuceneConnection %s", connection));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndUnlockIndexerQueue(@NotNull IndexerContext indexerContext) {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unlocking indexer for connection %s", indexerContext.getConnection().toString()));
            }
            ReentrantLock lock = this.getQueueOperationsLock(indexerContext);
            lock.lock();
            try {
                if (indexerContext.getIndexerLockStatus().compareAndSet(true, false)) {
                    ListenableFutureTask task;
                    ConcurrentLinkedQueue<ListenableFutureTask> queue = this.getIndexerQueue(indexerContext);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Submitting %d indexing requests that were queued while indexer was locked", queue.size()));
                    }
                    while ((task = queue.poll()) != null) {
                        this.submitRequest(indexerContext, task);
                    }
                    break block7;
                }
                throw new IllegalStateException(String.format("Queue for connection %s is already unlocked", indexerContext.getConnection()));
            }
            finally {
                lock.unlock();
            }
        }
    }

    @NotNull
    public List<Document> getMatchingDocuments(final @NotNull IndexerContext indexerContext, final @NotNull Query query) {
        ListenableFutureTask<List<Document>> task = IndexerServiceImpl.createAuthorisedTask(new Callable<List<Document>>(){

            @Override
            public List<Document> call() throws Exception {
                final ArrayList<Document> result = new ArrayList<Document>();
                indexerContext.getConnection().withSearch(new ILuceneConnection.SearcherAction(){

                    public void perform(IndexSearcher searcher) throws IOException {
                        IndexReader indexReader = searcher.getIndexReader();
                        TopDocs hits = searcher.search(query, 10000);
                        for (int i = 0; i < hits.scoreDocs.length; ++i) {
                            ScoreDoc scoreDoc = hits.scoreDocs[i];
                            result.add(indexReader.document(scoreDoc.doc));
                        }
                    }
                });
                return result;
            }
        });
        this.submitReadRequest(indexerContext, task);
        try {
            return (List)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)e.toString());
            log.debug(null, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    public <T> List<T> getMatchingDocuments(final @NotNull IndexerContext indexerContext, final @NotNull IndexSearcherTask<T> innerTask) {
        ListenableFutureTask task = IndexerServiceImpl.createAuthorisedTask(new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                final ArrayList result = new ArrayList();
                indexerContext.getConnection().withSearch(new ILuceneConnection.SearcherAction(){

                    public void perform(IndexSearcher searcher) throws IOException {
                        List taskResult = innerTask.withLuceneSearcher(searcher);
                        if (taskResult != null) {
                            result.addAll(taskResult);
                        }
                    }
                });
                return result;
            }
        });
        this.submitReadRequest(indexerContext, task);
        try {
            return (List)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)e.toString());
            log.debug(null, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    public ListenableFuture addDocument(final @NotNull IndexerContext indexerContext, final @NotNull Document document) {
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                indexerContext.getConnection().withWriter(new ILuceneConnection.WriterAction(){

                    public void perform(IndexWriter writer) throws IOException {
                        writer.addDocument((Iterable)document);
                    }
                });
            }
        }, null);
        this.submitWriteRequest(indexerContext, task);
        return task;
    }

    @NotNull
    public ListenableFuture addDocuments(final @NotNull IndexerContext indexerContext, @NotNull Iterable<Document> documents) {
        final ImmutableList documentsCopy = ImmutableList.copyOf(documents);
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                indexerContext.getConnection().withBatchUpdate(new ILuceneConnection.BatchUpdateAction(){

                    public void perform() throws Exception {
                        indexerContext.getConnection().withWriter(new ILuceneConnection.WriterAction(){

                            public void perform(IndexWriter writer) throws IOException {
                                for (Document document : documentsCopy) {
                                    writer.addDocument((Iterable)document);
                                }
                            }
                        });
                    }
                });
            }
        }, null);
        this.submitWriteRequest(indexerContext, task);
        return task;
    }

    @NotNull
    public ListenableFuture updateDocument(final @NotNull IndexerContext indexerContext, final @NotNull Term term, final @NotNull Document document) {
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                indexerContext.getConnection().withWriter(new ILuceneConnection.WriterAction(){

                    public void perform(IndexWriter writer) throws IOException {
                        writer.updateDocument(term, (Iterable)document);
                    }
                });
            }
        }, null);
        this.submitWriteRequest(indexerContext, task);
        return task;
    }

    @NotNull
    public ListenableFuture deleteDocuments(final @NotNull IndexerContext indexerContext, final @NotNull Term term) {
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                indexerContext.getConnection().withWriter(new ILuceneConnection.WriterAction(){

                    public void perform(IndexWriter writer) throws IOException {
                        writer.deleteDocuments(term);
                    }
                });
            }
        }, null);
        this.submitWriteRequest(indexerContext, task);
        return task;
    }

    @NotNull
    public ListenableFuture batchUpdate(final @NotNull IndexerContext indexerContext, final @NotNull IndexerTask task) {
        ListenableFutureTask batchUpdateTask = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                indexerContext.getConnection().withBatchUpdate(new ILuceneConnection.BatchUpdateAction(){

                    public void perform() throws Exception {
                        task.withLuceneConnection(indexerContext.getConnection());
                    }
                });
            }
        }, null);
        this.submitWriteRequest(indexerContext, batchUpdateTask);
        return batchUpdateTask;
    }

    @NotNull
    public ListenableFuture recreateIndexDirectory(final @NotNull IndexerContext indexerContext) {
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                indexerContext.getConnection().truncateIndex();
            }
        }, null);
        this.submitWriteRequest(indexerContext, task);
        return task;
    }

    private ReentrantLock getQueueOperationsLock(@NotNull IndexerContext indexerContext) {
        return this.getQueueOperationsLock(indexerContext.getConnection());
    }

    private ReentrantLock getQueueOperationsLock(@NotNull ILuceneConnection connection) {
        return (ReentrantLock)this.queueOperationsLockCache.getUnchecked((Object)connection);
    }

    @NotNull
    private ConcurrentLinkedQueue<ListenableFutureTask> getIndexerQueue(@NotNull IndexerContext indexerContext) {
        return (ConcurrentLinkedQueue)this.indexerQueueCache.getUnchecked((Object)indexerContext.getConnection());
    }

    private void submitReadRequest(@NotNull IndexerContext indexerContext, @NotNull ListenableFutureTask task) {
        if (indexerContext.canReadWhenLocked()) {
            this.submitRequest(indexerContext, task);
        } else {
            this.submitRequestCheckLock(indexerContext, task);
        }
    }

    private void submitWriteRequest(@NotNull IndexerContext indexerContext, @NotNull ListenableFutureTask task) {
        if (indexerContext.canWriteWhenLocked()) {
            this.submitRequest(indexerContext, task);
        } else {
            this.submitRequestCheckLock(indexerContext, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRequestCheckLock(@NotNull IndexerContext indexerContext, @NotNull ListenableFutureTask task) {
        ReentrantLock lock = this.getQueueOperationsLock(indexerContext);
        lock.lock();
        try {
            if (indexerContext.getIndexerLockStatus().get()) {
                this.queueRequest(indexerContext, task);
            } else {
                this.submitRequest(indexerContext, task);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void submitRequest(@NotNull IndexerContext indexerContext, @NotNull ListenableFutureTask task) {
        indexerContext.getExecutorService().execute((Runnable)task);
    }

    private void queueRequest(@NotNull IndexerContext indexerContext, @NotNull ListenableFutureTask task) {
        ConcurrentLinkedQueue<ListenableFutureTask> queue = this.getIndexerQueue(indexerContext);
        queue.add(task);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Queued indexing request, queue length for connection %s is %d", indexerContext.getConnection(), queue.size()));
        }
    }

    public static <V> ListenableFutureTask<V> createAuthorisedTask(final @NotNull Callable<V> callable) {
        final Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (currentAuthentication == null) {
            return ListenableFutureTask.create(callable);
        }
        Callable authorisedCallable = new Callable<V>(){

            @Override
            public V call() throws Exception {
                BambooRunnables.BambooRunnableFromCallable runnable = BambooRunnables.asBambooRunnable((Callable)callable);
                ImpersonationHelper.runWith((Authentication)currentAuthentication, (BambooRunnables.ThrowingX)runnable);
                return runnable.get();
            }
        };
        return ListenableFutureTask.create((Callable)authorisedCallable);
    }
}

