/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.buildresult;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.index.fields.IndexedEntityFieldFactory;
import com.atlassian.bamboo.index.fields.IndexedEntityIntegerField;
import com.atlassian.bamboo.index.fields.IndexedEntityLongField;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.results.ExtraBuildResultsData;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummaryImpl;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.NumberUtils;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildResultsSummaryDocument
extends AbstractResultsSummary
implements BuildResultsSummary {
    private static final Logger log = Logger.getLogger(BuildResultsSummaryDocument.class);
    public static final String FIELD_ID = "id";
    public static final String FIELD_BUILD_RESULT_ID = "buildResultId";
    public static final IndexedEntityIntegerField FIELD_BUILD_NUMBER = IndexedEntityFieldFactory.createIntegerField("buildNumber");
    public static final String FIELD_BUILD_KEY = "buildKey";
    public static final String FIELD_BUILD_ID = "buildId";
    public static final String FIELD_STORAGE_KEY = "storageKey";
    public static final String FIELD_PERMISSION_PLAN_ID = "permissionPlanId";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_LIFE_CYCLE_STATE = "lifeCycleState";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_COMPLETED_TIMESTAMP = "completedTimestamp";
    public static final String FIELD_DOC_TYPE = "docType";
    public static final String DOCTYPE_BUILD_RESULT = "buildResult";
    public static final IndexedEntityLongField FIELD_DURATION = IndexedEntityFieldFactory.createLongField("duration");
    static final IndexedEntityLongField FIELD_PROCESSING_DURATION = IndexedEntityFieldFactory.createLongField("processingDuration");
    public static final String FIELD_JIRA_ISSUE_KEY = "jiraIssueKey";
    public static final String FIELD_JIRA_ISSUE_KEY_FIXES = "fixingJiraIssueKey";
    public static final String FIELD_JIRA_PROJECT_KEY = "jiraProjectKey";
    public static final String FIELD_AUTHORS = "authors";
    public static final String FIELD_AUTHORS_LINKED_USER_SUFFIX = "linkedUserName";
    public static final String FIELD_TRIGGER_REASON_KEY = "triggerReasonKey";
    public static final String FIELD_DELTA_STATE = "deltaState";
    public static final String FIELD_LABELS = "labels";
    static final IndexedEntityLongField FIELD_TIME_TO_FIX = IndexedEntityFieldFactory.createLongField("timeToFix");
    public static final String FIELD_VCS_REVISION_KEY = "vcsRevisionKey";
    public static final IndexedEntityLongField FIELD_BUILD_AGENT_ID = IndexedEntityFieldFactory.createLongField("buildAgentId");
    public static final String FIELD_ARTIFACTS = "artifacts";
    public static final String FIELD_CUSTOM_DATA_PREFIX = "custom.data.";
    static final IndexedEntityIntegerField FIELD_TESTS_SUCCESS_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.successCount");
    static final IndexedEntityIntegerField FIELD_TESTS_FAILED_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.failedCount");
    static final IndexedEntityIntegerField FIELD_TESTS_FIXED_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.fixedCount");
    static final IndexedEntityIntegerField FIELD_TESTS_QUARANTINED_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.quarantinedCount");
    static final IndexedEntityIntegerField FIELD_TESTS_SKIPPED_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.skippedCount");
    static final IndexedEntityIntegerField FIELD_TESTS_BROKEN_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.brokenCount");
    static final IndexedEntityIntegerField FIELD_TESTS_EXISTING_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.existingCount");
    static final IndexedEntityIntegerField FIELD_TESTS_TOTAL_COUNT = IndexedEntityFieldFactory.createIntegerField("testSummary.totalCount");
    public static final String FIELD_QUEUE_TIME = "queueTime";
    public static final String FIELD_VCS_UPDATE_TIME = "vcsUpdateTime";
    public static final String FIELD_TYPE = "planType";
    public static final List<String> CUSTOM_DATA_MAP_KEYS_TO_INDEX = Arrays.asList("ScheduledTriggerReason.scheduledDate", "DependencyTriggerReason.triggeringBuildResultKey", "ManualBuildTriggerReason.userName", "ManualBuildTriggerReason.userName");
    private final Collection<String> jiraIssueKeys;
    private final List<String> labelNames;
    private final FinalHashSet<Author> uniqueAuthors = new FinalHashSet();
    private final FinalHashSet<LinkedJiraIssue> jiraIssues = new FinalHashSet();
    private Date queueTime;
    private Date vcsUpdateTime;
    final String[] artifactLabels;
    private final List<ArtifactLink> artifactsList = new ArrayList<ArtifactLink>();
    private final List<ArtifactLink> producedArtifactsList = new ArrayList<ArtifactLink>();
    private boolean isArtifactLinksFetched = false;
    private final ResultsSummaryManager resultsSummaryManager;
    private final ResettableLazyReference<Optional<ImmutableChain>> immutableChainLazyReference = new ResettableLazyReference<Optional<ImmutableChain>>(){

        @NotNull
        protected Optional<ImmutableChain> create() {
            ImmutableChain plan = (ImmutableChain)((CachedPlanManager)cachedPlanManagerRef.get()).getPlanByKey(PlanKeys.getChainKeyFromJobKey((PlanKey)BuildResultsSummaryDocument.this.getPlanKey()), ImmutableChain.class);
            return Optional.ofNullable(plan);
        }
    };

    public BuildResultsSummaryDocument(Document doc, @NotNull ResultsSummaryManager resultsSummaryManager) {
        Date dateField;
        this.resultsSummaryManager = resultsSummaryManager;
        this.setId(NumberUtils.stringToLong((String)doc.get(FIELD_ID)));
        this.setBuildNumber(FIELD_BUILD_NUMBER.getValue(doc, 0));
        this.setBuildKey(doc.get(FIELD_BUILD_KEY));
        this.setId(IndexUtils.getLongField(doc, FIELD_BUILD_ID));
        this.setBuildState(BuildState.getInstance((String)doc.get(FIELD_STATE)));
        this.lifeCycleState = LifeCycleState.getInstance((String)doc.get(FIELD_LIFE_CYCLE_STATE));
        Date buildDateString = IndexUtils.getDateField(doc, FIELD_TIMESTAMP);
        if (buildDateString != null) {
            this.setBuildDate(buildDateString);
        }
        if ((dateField = IndexUtils.getDateField(doc, FIELD_COMPLETED_TIMESTAMP)) != null) {
            this.setBuildCompletedDate(dateField);
        }
        this.setQueueTime(IndexUtils.getDateField(doc, FIELD_QUEUE_TIME));
        this.setVcsUpdateTime(IndexUtils.getDateField(doc, FIELD_VCS_UPDATE_TIME));
        this.setDuration(TimeUnit.SECONDS.toMillis(FIELD_DURATION.getValue(doc, 0L)));
        this.setProcessingDuration(TimeUnit.SECONDS.toMillis(FIELD_PROCESSING_DURATION.getValue(doc, 0L)));
        this.jiraIssueKeys = BambooCollectionUtils.stringArrayToList(doc.getValues(FIELD_JIRA_ISSUE_KEY));
        this.labelNames = BambooCollectionUtils.stringArrayToList(doc.getValues(FIELD_LABELS));
        this.setDeltaState(DeltaState.getInstance((String)doc.get(FIELD_DELTA_STATE)));
        this.setTimeToFix(FIELD_TIME_TO_FIX.getValue(doc, 0L));
        this.setBuildAgentId(FIELD_BUILD_AGENT_ID.getValue(doc, 0L));
        List<String> jiraIssueKeysFixing = BambooCollectionUtils.stringArrayToList(doc.getValues(FIELD_JIRA_ISSUE_KEY_FIXES));
        for (String string : this.jiraIssueKeys) {
            if (jiraIssueKeysFixing.contains(string)) {
                this.jiraIssues.add((Object)new LinkedJiraIssueImpl(string, JiraIssueLinkType.BUILD_FIXES));
                continue;
            }
            this.jiraIssues.add((Object)new LinkedJiraIssueImpl(string));
        }
        Set<String> uniqueAuthorNames = BambooCollectionUtils.stringArrayToHashSet(doc.getValues(FIELD_AUTHORS));
        for (String string : uniqueAuthorNames) {
            String linkedUserName = doc.get("authors." + string + "." + FIELD_AUTHORS_LINKED_USER_SUFFIX);
            this.uniqueAuthors.add((Object)new AuthorImpl(string, linkedUserName));
        }
        this.artifactLabels = doc.getValues(FIELD_ARTIFACTS);
        this.setCustomBuildData(new HashMap<String, String>());
        Map<String, String> map = this.getCustomBuildData();
        for (String key : CUSTOM_DATA_MAP_KEYS_TO_INDEX) {
            String value = doc.get(FIELD_CUSTOM_DATA_PREFIX + key);
            if (value == null) continue;
            map.put(key, value);
        }
        int n = FIELD_TESTS_SUCCESS_COUNT.getValue(doc, 0);
        int failedCount = FIELD_TESTS_FAILED_COUNT.getValue(doc, 0);
        int totalCount = FIELD_TESTS_TOTAL_COUNT.getValue(doc, 0);
        int newCount = FIELD_TESTS_BROKEN_COUNT.getValue(doc, 0);
        int existingCount = FIELD_TESTS_EXISTING_COUNT.getValue(doc, 0);
        int fixedCount = FIELD_TESTS_FIXED_COUNT.getValue(doc, 0);
        int quarantinedCount = FIELD_TESTS_QUARANTINED_COUNT.getValue(doc, 0);
        int skippedCount = FIELD_TESTS_SKIPPED_COUNT.getValue(doc, 0);
        this.setTestResultsSummary((TestResultsSummary)new TestResultsSummaryImpl(n, failedCount, totalCount, newCount, existingCount, fixedCount, quarantinedCount, skippedCount));
    }

    @NotNull
    public ImmutableChain getImmutableChain() {
        return (ImmutableChain)((Optional)this.immutableChainLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find chain for " + this.getPlanResultKey()));
    }

    @Override
    public Date getQueueTime() {
        return this.queueTime;
    }

    public long getQueueDuration() {
        return this.getVcsUpdateTime() != null && this.getQueueTime() != null ? this.getVcsUpdateTime().getTime() - this.getQueueTime().getTime() : 0L;
    }

    @Override
    public void setQueueTime(Date queueTime) {
        this.queueTime = queueTime;
    }

    public Date getVcsUpdateTime() {
        return this.vcsUpdateTime;
    }

    public long getVcsUpdateDuration() {
        return this.getBuildDate() != null && this.getVcsUpdateTime() != null ? this.getBuildDate().getTime() - this.getVcsUpdateTime().getTime() : 0L;
    }

    public void setVcsUpdateTime(Date vcsUpdateTime) {
        this.vcsUpdateTime = vcsUpdateTime;
    }

    @Override
    @NotNull
    public Set<LinkedJiraIssue> getJiraIssues() {
        return this.jiraIssues;
    }

    @Override
    public Set<String> getJiraIssueKeys() {
        return new HashSet<String>(this.jiraIssueKeys);
    }

    @Override
    public Set<Author> getUniqueAuthors() {
        return this.uniqueAuthors;
    }

    @Override
    @NotNull
    public List<ArtifactLink> getArtifactLinks() {
        this.fetchArtifactLinks(this.resultsSummaryManager);
        return this.artifactsList;
    }

    @NotNull
    public Collection<ArtifactLink> getProducedArtifactLinks() {
        this.fetchArtifactLinks(this.resultsSummaryManager);
        return this.producedArtifactsList;
    }

    @Override
    public List<Labelling> getLabellings() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<String> getLabelNames() {
        return this.labelNames;
    }

    public ChainResultsSummary getChainResultsSummary() {
        return null;
    }

    public void setChainResultsSummary(@NotNull ChainResultsSummary chainResultSummary) {
    }

    @NotNull
    public FilteredTestResults getFilteredTestResults() {
        throw new UnsupportedOperationException("Test results are not indexed");
    }

    @Override
    public void resetTestClassResults(@NotNull List<TestClassResult> testClassResults) {
        throw new UnsupportedOperationException("Test results are not indexed");
    }

    public boolean isMarkedForDeletion() {
        throw new UnsupportedOperationException("Marked for deletion information is not indexed in Lucene");
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        throw new UnsupportedOperationException("Marked for deletion information is not indexed in Lucene");
    }

    @NotNull
    public String getFullPlanName() {
        return this.getImmutableChain().getName() + " - " + this.getPlanName();
    }

    @Override
    @NotNull
    public String getPlanName() {
        return this.getPlanIfExists().map(PlanIdentifier::getBuildName).orElse(this.getPlanKey().getKey());
    }

    public boolean isNotRunYet() {
        return false;
    }

    @Nullable
    public ExtraBuildResultsData getExtraBuildResultsData() {
        return PersisterFactory.getInstance().getBuildResults((Key)this.getPlanKey(), this.getBuildNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchArtifactLinks(ResultsSummaryManager resultsSummaryManager) {
        List<ArtifactLink> list = this.artifactsList;
        synchronized (list) {
            if (!this.isArtifactLinksFetched) {
                ResultsSummary resultsSummary = resultsSummaryManager.getResultsSummary(this.getPlanResultKey());
                if (resultsSummary != null) {
                    this.artifactsList.addAll(resultsSummary.getArtifactLinks());
                    BuildResultsSummary buildResultsSummary = (BuildResultsSummary)Narrow.to((Object)resultsSummary, BuildResultsSummary.class);
                    if (buildResultsSummary != null) {
                        this.producedArtifactsList.addAll(buildResultsSummary.getProducedArtifactLinks());
                    }
                }
                this.isArtifactLinksFetched = true;
            }
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(31, 101).append((Object)this.getPlanKey()).append(this.getBuildNumber()).toHashCode();
    }

    @Override
    public int compareTo(ImmutableResultsSummary obj) {
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof BuildResultsSummaryDocument)) {
            throw new IllegalArgumentException("Cannot compare build result to a non-build result object.");
        }
        BuildResultsSummaryDocument o = (BuildResultsSummaryDocument)obj;
        return new CompareToBuilder().append((Object)this.getBuildDate(), (Object)o.getBuildDate()).toComparison();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof BuildResultsSummaryDocument)) {
            return false;
        }
        BuildResultsSummaryDocument summary = (BuildResultsSummaryDocument)object;
        return this.getPlanKey().equals((Object)summary.getPlanKey()) && this.getBuildNumber() == summary.getBuildNumber();
    }
}

