/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.buildresult;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.index.CustomIndexReader;
import com.atlassian.bamboo.index.CustomPostBuildIndexWriter;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.index.PostChainIndexWriter;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.index.buildresult.ChainResultsSummaryDocument;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.CustomIndexReaderModuleDescriptor;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildResultsSummaryDocumentFactory {
    private static final Logger log = Logger.getLogger(BuildResultsSummaryDocumentFactory.class);
    private final PluginAccessor pluginAccessor;
    private final TriggerManager triggerManager;
    private final StorageTagService storageTagService;
    private ResultsSummaryManager resultsSummaryManager;

    public BuildResultsSummaryDocumentFactory(PluginAccessor pluginAccessor, TriggerManager triggerManager, StorageTagService storageTagService) {
        this.pluginAccessor = pluginAccessor;
        this.triggerManager = triggerManager;
        this.storageTagService = storageTagService;
    }

    public Document getDocument(@NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan plan) {
        Document doc = new Document();
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#getDocument");){
            this.addRegularFieldsToDocument(doc, summary, chain, plan);
            this.addRepositoryChangesetsDataToDocument(doc, summary);
            this.addAuthorDataToDocument(doc, summary);
            this.addJiraDataToDocument(doc, summary);
            this.addArtifactDataToDocument(doc, summary);
            this.addLabelDataToDocument(doc, summary);
            if (summary instanceof BuildResultsSummary) {
                this.addBuildResultsSummarySpecificDataToDocument(doc, (BuildResultsSummary)summary);
            } else if (summary instanceof ChainResultsSummary) {
                this.addChainResultsSummarySpecificDataToDocument(doc, (ChainResultsSummary)summary);
            }
            this.addCustomBuildDataToDocument(doc, summary);
            this.addTestSummaryDataToDocument(doc, summary);
            this.addPluginGeneratedDataToDocument(doc, summary);
        }
        return doc;
    }

    public BuildResultsSummaryDocument getBuildResultsSummary(Document doc) {
        PlanKey planKey = PlanKeys.getPlanKey((String)doc.get("buildKey"));
        BuildResultsSummaryDocument buildResultsSummaryDocument = PlanKeys.isJobKey((PlanKey)planKey) ? new BuildResultsSummaryDocument(doc, this.resultsSummaryManager) : new ChainResultsSummaryDocument(doc, this.resultsSummaryManager);
        String triggerReasonKey = doc.get("triggerReasonKey");
        TriggerReason triggerReason = this.triggerManager.getTriggerReason(triggerReasonKey, (ResultsSummary)buildResultsSummaryDocument);
        buildResultsSummaryDocument.setTriggerReason(triggerReason);
        List list = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomIndexReaderModuleDescriptor.class);
        for (CustomIndexReaderModuleDescriptor readerModuleDescriptor : list) {
            CustomIndexReader reader = (CustomIndexReader)readerModuleDescriptor.getModule();
            if (reader == null) continue;
            reader.extractFromDocument(doc, (BuildResultsSummary)buildResultsSummaryDocument);
        }
        return buildResultsSummaryDocument;
    }

    private void addRegularFieldsToDocument(@NotNull Document doc, @NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan chainOrJob) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addRegularFieldsToDocument");){
            DeltaState deltaState;
            PlanType planType;
            IndexUtils.addFieldId("id", summary.getId(), doc);
            IndexUtils.addFieldId("buildResultId", summary.getId(), doc);
            if (chainOrJob != null && chainOrJob.getDatabaseId().isPresent()) {
                IndexUtils.addTypedField("buildId", chainOrJob.getId(), doc);
            }
            IndexUtils.addField("storageKey", this.storageTagService.getStorageLabel((Key)summary.getPlanKey()), doc);
            IndexUtils.addTypedField("permissionPlanId", PlanHelper.getPermissionPlanId((ImmutablePlan)chain), doc);
            PlanType planType2 = planType = PlanKeys.isJobKey((PlanKey)summary.getPlanKey()) ? PlanType.JOB : PlanType.CHAIN;
            if (PlanKeys.isJobKey((PlanKey)summary.getPlanKey())) {
                planType = PlanType.JOB;
            } else if (chain instanceof ImmutableChainBranch) {
                planType = PlanType.CHAIN;
            }
            IndexUtils.addField("planType", planType.name(), doc);
            IndexUtils.addField("docType", "buildResult", doc);
            IndexUtils.addField("buildKey", summary.getPlanKey().getKey(), doc);
            BuildResultsSummaryDocument.FIELD_BUILD_NUMBER.addToDocument(doc, (Object)summary.getBuildNumber());
            IndexUtils.addField("state", summary.getBuildState().toString(), doc);
            IndexUtils.addField("lifeCycleState", summary.getLifeCycleState().getValue(), doc);
            IndexUtils.addTypedField("timestamp", summary.getBuildDate(), doc);
            IndexUtils.addTypedField("completedTimestamp", summary.getBuildCompletedDate(), doc);
            BuildResultsSummaryDocument.FIELD_DURATION.addToDocument(doc, (Object)TimeUnit.MILLISECONDS.toSeconds(summary.getDuration()));
            BuildResultsSummaryDocument.FIELD_PROCESSING_DURATION.addToDocument(doc, (Object)TimeUnit.MILLISECONDS.toSeconds(summary.getProcessingDuration()));
            if (summary instanceof AbstractResultsSummary) {
                AbstractResultsSummary abstractResultsSummary = (AbstractResultsSummary)summary;
                IndexUtils.addField("triggerReasonKey", abstractResultsSummary.getTriggerReasonKey(), doc);
            }
            if ((deltaState = summary.getDeltaState()) != null) {
                IndexUtils.addField("deltaState", deltaState.toString(), doc);
            }
            BuildResultsSummaryDocument.FIELD_TIME_TO_FIX.addToDocument(doc, (Object)summary.getTimeToFix());
        }
    }

    private void addBuildResultsSummarySpecificDataToDocument(@NotNull Document doc, @NotNull BuildResultsSummary buildResultsSummary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addBuildResultsSummarySpecificDataToDocument");){
            IndexUtils.addTypedField("queueTime", buildResultsSummary.getQueueTime(), doc);
            IndexUtils.addTypedField("vcsUpdateTime", buildResultsSummary.getVcsUpdateTime(), doc);
            BuildResultsSummaryDocument.FIELD_BUILD_AGENT_ID.addToDocument(doc, (Object)buildResultsSummary.getBuildAgentId());
        }
    }

    private void addChainResultsSummarySpecificDataToDocument(@NotNull Document doc, @NotNull ChainResultsSummary chainResultsSummary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addChainResultsSummarySpecificDataToDocument");){
            ChainResultsSummaryDocument.FIELD_FIXED_IN.addToDocument(doc, (Object)chainResultsSummary.getFixedInResult());
            IndexUtils.addTypedField("queueTime", chainResultsSummary.getQueueTime(), doc);
            ChainResultsSummaryDocument.FIELD_QUEUE_DURATION.addToDocument(doc, (Object)this.resultsSummaryManager.calculateQueueDuration(chainResultsSummary));
            ChainResultsSummaryDocument.FIELD_VCS_UPDATE_DURATION.addToDocument(doc, (Object)this.resultsSummaryManager.calculateVcsUpdateDuration(chainResultsSummary));
        }
    }

    private void addAuthorDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addAuthorDataToDocument");){
            for (Author author : Iterables.filter((Iterable)summary.getUniqueAuthors(), Objects::nonNull)) {
                IndexUtils.addField("authors", author.getName(), doc);
                IndexUtils.addField("authors." + author.getName() + "." + "linkedUserName", author.getLinkedUserName(), doc);
            }
        }
    }

    private void addRepositoryChangesetsDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addRepositoryChangesetsDataToDocument");){
            for (RepositoryChangeset revisionKey : Iterables.filter((Iterable)summary.getRepositoryChangesets(), Objects::nonNull)) {
                IndexUtils.addField("vcsRevisionKey", revisionKey.getChangesetId(), doc);
            }
        }
    }

    private void addLabelDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addLabelDataToDocument");){
            for (String label : summary.getLabelNames()) {
                IndexUtils.addField("labels", label, doc);
            }
        }
    }

    private void addArtifactDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addArtifactDataToDocument");){
            if (summary.isFinished()) {
                for (ArtifactLink artifact : summary.getArtifactLinks()) {
                    IndexUtils.addField("artifacts", artifact.getLabel(), doc);
                }
            }
        }
    }

    private void addJiraDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addJiraDataToDocument");){
            HashSet<String> jiraProjectKeys = new HashSet<String>();
            for (LinkedJiraIssue issue : summary.getJiraIssues()) {
                String jiraProjectKey;
                IndexUtils.addField("jiraIssueKey", issue.getIssueKey(), doc);
                if (issue.getIssueType() == JiraIssueLinkType.BUILD_FIXES) {
                    IndexUtils.addField("fixingJiraIssueKey", issue.getIssueKey(), doc);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(jiraProjectKey = StringUtils.substringBefore((String)issue.getIssueKey(), (String)"-")))) continue;
                jiraProjectKeys.add(jiraProjectKey);
            }
            for (String jiraProjectKey : jiraProjectKeys) {
                IndexUtils.addField("jiraProjectKey", jiraProjectKey, doc);
            }
        }
    }

    private void addCustomBuildDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addCustomBuildDataToDocument");){
            Map customDataMap = summary.getCustomBuildData();
            for (String key : BuildResultsSummaryDocument.CUSTOM_DATA_MAP_KEYS_TO_INDEX) {
                String customDataValue = (String)customDataMap.get(key);
                if (customDataValue == null) continue;
                IndexUtils.addField("custom.data." + key, customDataValue, doc);
            }
        }
    }

    private void addTestSummaryDataToDocument(@NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addTestSummaryDataToDocument");){
            TestResultsSummary testSummary = summary.getTestResultsSummary();
            BuildResultsSummaryDocument.FIELD_TESTS_SUCCESS_COUNT.addToDocument(doc, (Object)testSummary.getSuccessfulTestCaseCount());
            BuildResultsSummaryDocument.FIELD_TESTS_FAILED_COUNT.addToDocument(doc, (Object)testSummary.getFailedTestCaseCount());
            BuildResultsSummaryDocument.FIELD_TESTS_TOTAL_COUNT.addToDocument(doc, (Object)testSummary.getTotalTestCaseCount());
            BuildResultsSummaryDocument.FIELD_TESTS_BROKEN_COUNT.addToDocument(doc, (Object)testSummary.getNewFailedTestCaseCount());
            BuildResultsSummaryDocument.FIELD_TESTS_EXISTING_COUNT.addToDocument(doc, (Object)testSummary.getExistingFailedTestCount());
            BuildResultsSummaryDocument.FIELD_TESTS_FIXED_COUNT.addToDocument(doc, (Object)testSummary.getFixedTestCaseCount());
            BuildResultsSummaryDocument.FIELD_TESTS_QUARANTINED_COUNT.addToDocument(doc, (Object)testSummary.getQuarantinedTestCaseCount());
            BuildResultsSummaryDocument.FIELD_TESTS_SKIPPED_COUNT.addToDocument(doc, (Object)testSummary.getSkippedTestCaseCount());
        }
    }

    private void addPluginGeneratedDataToDocument(final @NotNull Document doc, @NotNull ResultsSummary summary) {
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryDocumentFactory#addPluginGeneratedDataToDocument");){
            ChainResultsSummary chainResultsSummary;
            final BuildResultsSummary buildResultsSummary = (BuildResultsSummary)Narrow.to((Object)summary, BuildResultsSummary.class);
            if (buildResultsSummary != null) {
                for (final CustomPostBuildIndexWriter indexWriter : this.pluginAccessor.getEnabledModulesByClass(CustomPostBuildIndexWriter.class)) {
                    String errorMessage = String.format("IndexWriter %s has failed updating document", indexWriter.getClass());
                    BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                        @Override
                        public void run() {
                            indexWriter.updateIndexDocument(doc, buildResultsSummary);
                        }
                    });
                }
            }
            if ((chainResultsSummary = (ChainResultsSummary)Narrow.to((Object)summary, ChainResultsSummary.class)) != null) {
                for (final PostChainIndexWriter indexWriter : this.pluginAccessor.getEnabledModulesByClass(PostChainIndexWriter.class)) {
                    String errorMessage = String.format("IndexWriter %s has failed updating document", indexWriter.getClass());
                    BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                        @Override
                        public void run() {
                            indexWriter.updateIndexDocument(doc, chainResultsSummary);
                        }
                    });
                }
            }
        }
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

