/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.buildresult;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.index.fields.IndexedEntityFieldFactory;
import com.atlassian.bamboo.index.fields.IndexedEntityIntegerField;
import com.atlassian.bamboo.index.fields.IndexedEntityLongField;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultDescriptor;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainResultsSummaryDocument
extends BuildResultsSummaryDocument
implements ChainResultsSummary {
    private static final Logger log = Logger.getLogger(ChainResultsSummaryDocument.class);
    public static final IndexedEntityIntegerField FIELD_FIXED_IN = IndexedEntityFieldFactory.createIntegerField("fixedInBuild");
    public static final IndexedEntityLongField FIELD_QUEUE_DURATION = IndexedEntityFieldFactory.createLongField("queueDuration");
    public static final IndexedEntityLongField FIELD_VCS_UPDATE_DURATION = IndexedEntityFieldFactory.createLongField("vcsUpdateDuration");
    private final ResettableLazyReference<Optional<ImmutableChain>> immutableChainLazyReference = new ResettableLazyReference<Optional<ImmutableChain>>(){

        @NotNull
        protected Optional<ImmutableChain> create() {
            ImmutableChain plan = (ImmutableChain)((CachedPlanManager)cachedPlanManagerRef.get()).getPlanByKey(ChainResultsSummaryDocument.this.getPlanKey(), ImmutableChain.class);
            return Optional.ofNullable(plan);
        }
    };
    private Integer fixedInResult;
    private long queueDuration;
    private long vcsUpdateDuration;

    public ChainResultsSummaryDocument(Document doc, @NotNull ResultsSummaryManager resultsSummaryManager) {
        super(doc, resultsSummaryManager);
        this.fixedInResult = (Integer)FIELD_FIXED_IN.getValue(doc);
        this.queueDuration = FIELD_QUEUE_DURATION.getValue(doc, 0L);
        this.vcsUpdateDuration = FIELD_VCS_UPDATE_DURATION.getValue(doc, 0L);
    }

    @NotNull
    public ImmutableChain getImmutablePlan() {
        return (ImmutableChain)((Optional)this.immutableChainLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find Plan for " + this.getPlanResultKey()));
    }

    @Override
    @NotNull
    public ImmutableChain getImmutableChain() {
        return (ImmutableChain)((Optional)this.immutableChainLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find chain for " + this.getPlanResultKey()));
    }

    @NotNull
    public Optional<ImmutableChain> getPlanIfExists() {
        return (Optional)this.immutableChainLazyReference.get();
    }

    @Override
    @NotNull
    public String getFullPlanName() {
        return this.getImmutablePlan().getName();
    }

    @NotNull
    public List<ChainStageResult> getStageResults() {
        throw new UnsupportedOperationException("Stage results are not indexed in Lucene");
    }

    @NotNull
    public ChainStageResult createStageResult(@NotNull ImmutableChainStage chainStage) {
        throw new UnsupportedOperationException("Cannot create stage results from a Lucene results summary");
    }

    public boolean addStageResult(@NotNull ChainStageResult chainStageResult) {
        throw new UnsupportedOperationException("Cannot add Stage results to a Lucene results summary");
    }

    public boolean removeStageResult(@NotNull ChainStageResult chainStageResult) {
        throw new UnsupportedOperationException("Cannot remove Stage results to a Lucene results summary");
    }

    @NotNull
    public List<BuildResultsSummary> getFailedJobResults() {
        throw new UnsupportedOperationException("Stage results are not indexed in Lucene");
    }

    public int getTotalJobCount() {
        throw new UnsupportedOperationException("Stage results are not indexed in Lucene");
    }

    @NotNull
    public List<ResultsSummary> getOrderedJobResultSummaries() {
        return Collections.emptyList();
    }

    public boolean isContinuable() {
        return false;
    }

    public void setContinuable(boolean chainContinuable) {
    }

    public boolean isRestartable() {
        return false;
    }

    public Integer getFixedInResult() {
        return this.fixedInResult;
    }

    public void setFixedInResult(Integer fixedInBuild) {
        this.fixedInResult = fixedInBuild;
    }

    public FilteredTestResults<TestClassResultDescriptor> getTestResults() {
        throw new UnsupportedOperationException("Test results are not indexed");
    }

    public MergeResultSummary getMergeResult() {
        throw new UnsupportedOperationException("Merge results are not indexed");
    }

    public void setMergeResult(@Nullable MergeResultSummary mergeResult) {
        throw new UnsupportedOperationException("Cannot add Merge results to a Lucene results summary");
    }

    @Override
    public long getQueueDuration() {
        return this.queueDuration;
    }

    @Override
    public long getVcsUpdateDuration() {
        return this.vcsUpdateDuration;
    }
}

