/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.buildresult;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.index.AbstractIndexer;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.index.Indexer;
import com.atlassian.bamboo.index.IndexerBandanaContext;
import com.atlassian.bamboo.index.IndexerContext;
import com.atlassian.bamboo.index.IndexerService;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocumentFactory;
import com.atlassian.bamboo.index.buildresult.events.ChainDeindexedEvent;
import com.atlassian.bamboo.index.buildresult.events.ChainIndexedEvent;
import com.atlassian.bamboo.index.buildresult.events.ChainResultDeindexedEvent;
import com.atlassian.bamboo.index.buildresult.events.ChainResultIndexedEvent;
import com.atlassian.bamboo.index.buildresult.events.ChainResultUpdateIndexedEvent;
import com.atlassian.bamboo.index.events.IndexingFinishedEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBuildResultsIndexer
extends AbstractIndexer
implements BuildResultsIndexer {
    private static final Logger log = Logger.getLogger(DefaultBuildResultsIndexer.class);
    private final BuildResultsSummaryDao buildResultsSummaryDao;
    private final BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory;
    private final CachedPlanManager cachedPlanManager;
    private final EventPublisher eventPublisher;

    public DefaultBuildResultsIndexer(ILuceneConnection luceneConnection, BandanaManager bandanaManager, HibernateConfig hibernateConfig, IndexerService indexerService, BuildResultsSummaryDao buildResultsSummaryDao, BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory, CachedPlanManager cachedPlanManager, EventPublisher eventPublisher) {
        super(luceneConnection, bandanaManager, BambooHibernateUtils.getMaxConnectionPoolSize(hibernateConfig), indexerService);
        this.buildResultsSummaryDao = buildResultsSummaryDao;
        this.buildResultsSummaryDocumentFactory = buildResultsSummaryDocumentFactory;
        this.cachedPlanManager = cachedPlanManager;
        this.eventPublisher = eventPublisher;
    }

    public void indexAll(@NotNull Executor executor) throws Exception {
        List plansKeysSortedByResultCount = this.buildResultsSummaryDao.getPlanKeysSortedByNumberOfFinalizedResultSummaries();
        if (!plansKeysSortedByResultCount.isEmpty()) {
            IndexerContext indexerContext = this.lockIndexerQueue();
            int tasksToProcess = plansKeysSortedByResultCount.size();
            int versionsCount = this.buildResultsSummaryDao.countBuildResultsSummaries();
            AbstractIndexer.FlushAndUnlockIndexerQueueCallback flushAndUnlockIndexerQueueCallback = new AbstractIndexer.FlushAndUnlockIndexerQueueCallback((AbstractIndexer)this, tasksToProcess, indexerContext);
            AbstractIndexer.UpdateApproximateIndexingTimePerResultCallback updateApproximateIndexingTimePerResultCallback = new AbstractIndexer.UpdateApproximateIndexingTimePerResultCallback((AbstractIndexer)this, tasksToProcess, versionsCount);
            for (PlanKey planKey : plansKeysSortedByResultCount) {
                ListenableFutureTask<Long> indexPlanTask = this.createIndexPlanTask(indexerContext, planKey);
                Futures.addCallback(indexPlanTask, (FutureCallback)flushAndUnlockIndexerQueueCallback);
                Futures.addCallback(indexPlanTask, (FutureCallback)updateApproximateIndexingTimePerResultCallback);
                executor.execute((Runnable)indexPlanTask);
            }
        }
    }

    public long indexChain(ImmutableChain plan) {
        return this.indexPlan(plan, plan.getPlanKey(), (ImmutablePlan)plan);
    }

    public long indexJob(ImmutableJob plan) {
        return this.indexPlan(plan.getParent(), plan.getPlanKey(), (ImmutablePlan)plan);
    }

    public long indexJob(ImmutableChain immutableChain, PlanKey jobKey) {
        return this.indexPlan(immutableChain, jobKey, this.cachedPlanManager.getPlanByKey(jobKey));
    }

    private long indexPlan(ImmutableChain chain, PlanKey planKey, @Nullable ImmutablePlan plan) {
        String planName = plan != null ? plan.getName() : chain.getName() + " - " + planKey;
        log.info((Object)("Starting re-index for plan '" + planName + "' (" + planKey + ")"));
        Stopwatch stopWatch = Stopwatch.createStarted();
        this.indexPlan(this.getDefaultIndexerContext(), chain, planKey, plan);
        log.info((Object)("Completed reindexing plan '" + planName + "' (" + planKey + "). Took: " + stopWatch));
        return stopWatch.elapsed(TimeUnit.MILLISECONDS);
    }

    public void indexResultSummary(@NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan plan) {
        ListenableFuture future = this.indexResultSummaryInternal(summary, chain, plan);
        if (future != null && summary instanceof ChainResultsSummary) {
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FireEvent(new ChainResultIndexedEvent((Indexer)this, summary.getPlanResultKey())));
        }
    }

    @NotNull
    private ListenableFuture indexResultSummaryInternal(final @NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan plan) {
        if (summary.getBuildDate() == null) {
            log.info((Object)("build result doesn't have buildDate, so ignored " + summary.getPlanResultKey()));
            return Futures.immediateFuture(null);
        }
        ListenableFuture future = this.indexerService.updateDocument(this.getDefaultIndexerContext(), new Term("buildResultId", Long.toString(summary.getId())), this.buildResultsSummaryDocumentFactory.getDocument(summary, chain, plan));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback(){

            public void onSuccess(Object result) {
                log.info((Object)String.format("Indexed %s", summary.getPlanResultKey()));
            }

            public void onFailure(Throwable t) {
                log.warn((Object)String.format("Failed to index build results %s", summary.getPlanResultKey()), t);
            }
        });
        return future;
    }

    private ListenableFuture reIndexBuildResultsInternal(@NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan plan) throws Exception {
        try {
            log.info((Object)("Indexing " + summary.getPlanResultKey()));
            return this.indexResultSummaryInternal(summary, chain, plan);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to reindex build " + summary.getPlanResultKey() + ". Statistics may be inconsistent."), (Throwable)e);
            return null;
        }
    }

    public void reIndexBuildResults(@NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan plan, @Nullable Set<String> affectedJiraIssuesKeys, boolean includeTests) throws Exception {
        ListenableFuture future = this.reIndexBuildResultsInternal(summary, chain, plan);
        if (future != null && summary instanceof ChainResultsSummary) {
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FireEvent(new ChainResultUpdateIndexedEvent((Indexer)this, summary.getPlanResultKey(), affectedJiraIssuesKeys)));
        }
    }

    public void reIndexBuildResults(@NotNull ResultsSummary summary, @NotNull ImmutableChain chain, @Nullable ImmutablePlan plan, boolean includeTests) throws Exception {
        this.reIndexBuildResults(summary, chain, plan, Collections.emptySet(), includeTests);
    }

    private ListenableFuture deIndexBuildInternal(@NotNull PlanKey planKey) throws Exception {
        return this.indexerService.deleteDocuments(this.getDefaultIndexerContext(), LuceneQueryBuilder.term("buildKey", planKey.getKey()));
    }

    public void deIndexBuild(@NotNull PlanKey planKey) throws Exception {
        this.deIndexBuildInternal(planKey);
    }

    public void deIndexBuild(@NotNull PlanKey planKey, @NotNull Set<String> affectedJiraIssuesKeys) throws Exception {
        ListenableFuture future = this.deIndexBuildInternal(planKey);
        if (PlanKeys.isChainKey((PlanKey)planKey)) {
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FireEvent(new ChainDeindexedEvent((Indexer)this, planKey, affectedJiraIssuesKeys)));
        }
    }

    public void deIndexBuildResults(ResultsSummary summary, boolean includeTests) {
        this.deIndexBuildResultsInternal(summary, includeTests);
    }

    private ListenableFuture deIndexBuildResultsInternal(ResultsSummary summary, boolean includeTests) {
        String docField = includeTests ? "buildResultId" : "id";
        return this.indexerService.deleteDocuments(this.getDefaultIndexerContext(), new Term(docField, Long.toString(summary.getId())));
    }

    @Deprecated
    public void deIndexChainResults(@NotNull ChainResultsSummary summary, Set<String> affectedJiraIssuesKeys, boolean includeTests) {
        ListenableFuture future = this.deIndexBuildResultsInternal((ResultsSummary)summary, includeTests);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FireEvent(new ChainResultDeindexedEvent((Indexer)this, summary.getPlanResultKey(), affectedJiraIssuesKeys)));
    }

    public long getEstimatedReindexTime() {
        long approximateIndexingTime = this.getApproximateIndexingTimePerResult() * (long)this.buildResultsSummaryDao.countBuildResultsSummaries() / (long)this.getConcurrentIndexers();
        return TimeUnit.MILLISECONDS.toSeconds(approximateIndexingTime);
    }

    protected BambooBandanaContext getIndexerBandanaContext() {
        return IndexerBandanaContext.forIndexer((Indexer)this);
    }

    @NotNull
    private ListenableFutureTask<Long> createIndexPlanTask(@NotNull IndexerContext indexerContext, @NotNull PlanKey planKey) {
        return ListenableFutureTask.create((Callable)((Object)new IndexPlanTask(indexerContext, planKey)));
    }

    @VisibleForTesting
    protected void updateApproximateIndexingTimePerResult(long totalIndexingTime, int entityCount) {
        super.updateApproximateIndexingTimePerResult(totalIndexingTime, entityCount);
    }

    private void indexPlan(@NotNull IndexerContext indexerContext, @NotNull ImmutableChain chain, @NotNull PlanKey planKey, @Nullable ImmutablePlan plan) {
        try (Ticker ignored = Timers.start((String)"DefaultBuildResultsIndexer#indexPlan");){
            FireBuildIndexedFinishedEvent fireEventCallback = new FireBuildIndexedFinishedEvent(plan instanceof Chain ? new ChainIndexedEvent((Indexer)this, plan.getPlanKey()) : null);
            int BATCH_SIZE = 100;
            Stopwatch stopWatch = Stopwatch.createStarted();
            LinkedList documents = new LinkedList();
            AtomicInteger recordsProcessed = new AtomicInteger(0);
            this.buildResultsSummaryDao.scrollResultSummaries(planKey.getKey(), ResultDataRead.FULL, resultsSummary -> {
                try (Ticker ignored1 = Timers.start((String)"DefaultBuildResultsIndexer#indexPlan#createDocument");){
                    if (resultsSummary.getBuildDate() != null) {
                        documents.add(this.buildResultsSummaryDocumentFactory.getDocument((ResultsSummary)resultsSummary, chain, plan));
                    }
                }
                if (recordsProcessed.incrementAndGet() % 100 == 0) {
                    var11_11 = null;
                    try (Ticker ignored2 = Timers.start((String)"DefaultBuildResultsIndexer#indexPlan#indexerService.addDocuments()");){
                        fireEventCallback.incrementCounter();
                        ListenableFuture future = this.indexerService.addDocuments(indexerContext, (Iterable)documents);
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)fireEventCallback);
                    }
                    catch (Throwable throwable) {
                        var11_11 = throwable;
                        throw throwable;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Indexed %d summaries for plan %s, took: %s", recordsProcessed.get(), planKey, stopWatch));
                    }
                    documents.clear();
                }
            });
            if (!documents.isEmpty()) {
                fireEventCallback.incrementCounter();
                ListenableFuture future = this.indexerService.addDocuments(indexerContext, documents);
                Futures.addCallback((ListenableFuture)future, (FutureCallback)fireEventCallback);
                log.info((Object)String.format("Completed indexing plan %s: %d summaries in %s", planKey, recordsProcessed.get(), stopWatch));
            }
            fireEventCallback.publishEventIfReady();
        }
    }

    private class IndexPlanTask
    extends AbstractIndexer.IndexAllCallable {
        private final PlanKey planKey;

        private IndexPlanTask(@NotNull IndexerContext indexerContext, PlanKey planKey) {
            super((AbstractIndexer)DefaultBuildResultsIndexer.this, indexerContext);
            this.planKey = planKey;
        }

        public void run() {
            try (Ticker ignored = Timers.start((String)"IndexPlanTask#run");){
                PlanKey chainKey = PlanKeys.isJobKey((PlanKey)this.planKey) ? PlanKeys.getChainKeyFromJobKey((PlanKey)this.planKey) : this.planKey;
                ImmutableChain chain = (ImmutableChain)DefaultBuildResultsIndexer.this.cachedPlanManager.getPlanByKey(chainKey, ImmutableChain.class);
                if (chain != null) {
                    if (PlanKeys.isJobKey((PlanKey)this.planKey)) {
                        DefaultBuildResultsIndexer.this.indexPlan(this.indexerContext, chain, this.planKey, DefaultBuildResultsIndexer.this.cachedPlanManager.getPlanByKey(this.planKey));
                    } else {
                        DefaultBuildResultsIndexer.this.indexPlan(this.indexerContext, chain, this.planKey, (ImmutablePlan)chain);
                    }
                } else {
                    log.warn((Object)String.format("Plan %s became unavailable and will not be indexed", this.planKey));
                }
            }
        }
    }

    private class FireBuildIndexedFinishedEvent
    implements FutureCallback {
        private AtomicInteger counter;
        private final ChainIndexedEvent event;

        private FireBuildIndexedFinishedEvent(ChainIndexedEvent event) {
            this.event = event;
            this.counter = new AtomicInteger(1);
        }

        public void incrementCounter() {
            this.counter.incrementAndGet();
        }

        public synchronized void publishEventIfReady() {
            int value = this.counter.decrementAndGet();
            if (value <= 0 && this.event != null) {
                DefaultBuildResultsIndexer.this.eventPublisher.publish((Object)this.event);
            }
        }

        public void onSuccess(Object result) {
            this.publishEventIfReady();
        }

        public void onFailure(Throwable t) {
            log.warn((Object)"Unexpected error while indexing.", t);
            this.publishEventIfReady();
        }
    }

    private class FireEvent
    implements FutureCallback {
        private final IndexingFinishedEvent event;

        private FireEvent(IndexingFinishedEvent event) {
            this.event = event;
        }

        public void onSuccess(Object result) {
            DefaultBuildResultsIndexer.this.eventPublisher.publish((Object)this.event);
        }

        public void onFailure(Throwable t) {
            log.warn((Object)("Unexpected error while indexing. Event " + this.event.getClass().getName() + " will not be fired"), t);
        }
    }
}

