/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.buildresult;

import com.atlassian.bamboo.event.HibernateEventListener;
import com.atlassian.bamboo.event.InlineEventListener;
import com.atlassian.bamboo.event.ResultsSummaryUpdatedEvent;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.event.Event;
import org.apache.log4j.Logger;

public class ResultsSummaryIndexingListener
implements HibernateEventListener,
InlineEventListener {
    private static final Logger log = Logger.getLogger(ResultsSummaryIndexingListener.class);
    private BuildResultsIndexer buildResultsIndexer;
    private CachedPlanManager cachedPlanManager;
    private ResultsSummaryManager resultsSummaryManager;

    public void handleEvent(Event event) {
        if (event instanceof ResultsSummaryUpdatedEvent) {
            ResultsSummary summary;
            ResultsSummaryUpdatedEvent rsUpdatedEvent = (ResultsSummaryUpdatedEvent)event;
            PlanResultKey planResultKey = rsUpdatedEvent.getPlanResultKey();
            PlanKey chainKey = PlanKeys.isJobKey((PlanKey)planResultKey.getPlanKey()) ? PlanKeys.getChainKeyIfJobKey((PlanKey)planResultKey.getPlanKey()) : planResultKey.getPlanKey();
            ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(chainKey, ImmutableChain.class);
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planResultKey.getPlanKey(), ImmutablePlan.class);
            if (chain != null && (summary = this.resultsSummaryManager.getResultsSummary(planResultKey, ResultsSummary.class, ResultDataRead.EAGER)) != null) {
                try {
                    this.buildResultsIndexer.reIndexBuildResults(summary, chain, plan, rsUpdatedEvent.getAffectedJiraIssuesKeys(), false);
                }
                catch (Exception e) {
                    log.error((Object)("Attempt to reindex build results " + planResultKey.getKey() + " failed. "), (Throwable)e);
                }
            }
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{ResultsSummaryUpdatedEvent.class};
    }

    public void setBuildResultsIndexer(BuildResultsIndexer buildResultsIndexer) {
        this.buildResultsIndexer = buildResultsIndexer;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

