/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.IndexedEntityField;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractIndexedEntityField<T>
implements IndexedEntityField<T> {
    private static final Logger log = Logger.getLogger(AbstractIndexedEntityField.class);
    protected final String fieldId;
    protected final Field.Store stored;

    protected AbstractIndexedEntityField(@NotNull String fieldId, @NotNull Field.Store stored) {
        this.fieldId = fieldId;
        this.stored = stored;
    }

    @NotNull
    public String getFieldId() {
        return this.fieldId;
    }

    @Nullable
    public T getValue(@NotNull Document document) {
        IndexableField field = document.getField(this.fieldId);
        if (field != null) {
            return this.valueFromField(field);
        }
        return null;
    }

    public void addToDocument(@NotNull Document document, @Nullable T value) {
        if (value != null) {
            document.add(this.valueToField(value));
        } else {
            log.debug((Object)("Field " + this.fieldId + " not indexed as value is null."));
        }
    }

    public void removeFromDocument(@NotNull Document document) {
        document.removeField(this.fieldId);
    }

    @NotNull
    public Term createTerm(@NotNull T value) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Query createQuery(@NotNull T value) {
        return new TermQuery(this.createTerm(value));
    }

    @NotNull
    public Term createTerm(@NotNull Document document) {
        IndexableField field = (IndexableField)Preconditions.checkNotNull((Object)document.getField(this.fieldId), (Object)String.format("%s doesn't identify existing field", this.fieldId));
        Object value = Preconditions.checkNotNull(this.valueFromField(field), (Object)String.format("%s doesn't identify field with correct value", this.fieldId));
        return this.createTerm(value);
    }

    @NotNull
    public Function<Document, T> getValueFunction() {
        return new Function<Document, T>(){

            public T apply(@Nullable Document input) {
                return AbstractIndexedEntityField.this.getValue((Document)Preconditions.checkNotNull((Object)input));
            }
        };
    }

    @Nullable
    protected abstract T valueFromField(@NotNull IndexableField var1);

    @NotNull
    protected abstract IndexableField valueToField(@NotNull T var1);
}

