/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.AbstractIndexedEntityField;
import com.atlassian.bamboo.index.fields.IndexedEntityDateField;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedEntityDateFieldImpl
extends AbstractIndexedEntityField<Date>
implements IndexedEntityDateField {
    private static final Logger log = Logger.getLogger(IndexedEntityDateFieldImpl.class);

    protected IndexedEntityDateFieldImpl(@NotNull String fieldId, @NotNull Field.Store stored) {
        super(fieldId, stored);
    }

    @Override
    @Nullable
    protected Date valueFromField(@NotNull IndexableField field) {
        Number value = field.numericValue();
        if (value != null) {
            return new Date(value.longValue());
        }
        log.info((Object)String.format("Field %s doesn't contain proper date value", field.name()));
        return null;
    }

    @Override
    @NotNull
    protected IndexableField valueToField(@NotNull Date value) {
        return new LongField(this.fieldId, value.getTime(), this.stored);
    }
}

