/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.AbstractIndexedEntityField;
import com.atlassian.bamboo.index.fields.IndexedEntityEnumField;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedEntityEnumFieldImpl<T extends Enum<T>>
extends AbstractIndexedEntityField<T>
implements IndexedEntityEnumField<T> {
    private static final Logger log = Logger.getLogger(IndexedEntityEnumFieldImpl.class);
    private final Class<T> enumType;

    protected IndexedEntityEnumFieldImpl(@NotNull Class<T> enumType, @NotNull String fieldId, @NotNull Field.Store stored) {
        super(fieldId, stored);
        this.enumType = enumType;
    }

    @Override
    @Nullable
    protected T valueFromField(@NotNull IndexableField field) {
        String value = field.stringValue();
        try {
            return Enum.valueOf(this.enumType, value);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)String.format("Incorrect value '%s' in field '%s', null will be returned", value, field), (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    protected IndexableField valueToField(@NotNull T value) {
        return new StringField(this.fieldId, ((Enum)value).name(), this.stored);
    }
}

