/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.IndexedEntityDateField;
import com.atlassian.bamboo.index.fields.IndexedEntityDateFieldImpl;
import com.atlassian.bamboo.index.fields.IndexedEntityEnumField;
import com.atlassian.bamboo.index.fields.IndexedEntityEnumFieldImpl;
import com.atlassian.bamboo.index.fields.IndexedEntityIdField;
import com.atlassian.bamboo.index.fields.IndexedEntityIdFieldImpl;
import com.atlassian.bamboo.index.fields.IndexedEntityIntegerField;
import com.atlassian.bamboo.index.fields.IndexedEntityIntegerFieldImpl;
import com.atlassian.bamboo.index.fields.IndexedEntityLongField;
import com.atlassian.bamboo.index.fields.IndexedEntityLongFieldImpl;
import com.atlassian.bamboo.index.fields.IndexedEntityPlanResultKeyField;
import com.atlassian.bamboo.index.fields.IndexedEntityPlanResultKeyFieldImpl;
import com.atlassian.bamboo.index.fields.IndexedEntityTextField;
import com.atlassian.bamboo.index.fields.IndexedEntityTextFieldImpl;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.jetbrains.annotations.NotNull;

public class IndexedEntityFieldFactory {
    private static final Logger log = Logger.getLogger(IndexedEntityFieldFactory.class);

    private IndexedEntityFieldFactory() {
    }

    public static IndexedEntityDateField createDateField(@NotNull String fieldId) {
        return new IndexedEntityDateFieldImpl(fieldId, Field.Store.YES);
    }

    @NotNull
    public static IndexedEntityIdField createIdField(@NotNull String fieldId) {
        return new IndexedEntityIdFieldImpl(fieldId, Field.Store.YES);
    }

    public static IndexedEntityPlanResultKeyField createPlanResultKeyField(@NotNull String fieldId) {
        return new IndexedEntityPlanResultKeyFieldImpl(fieldId, Field.Store.YES);
    }

    public static IndexedEntityTextField createTextField(@NotNull String fieldId) {
        return IndexedEntityFieldFactory.createTextField(fieldId, Field.Store.YES);
    }

    public static IndexedEntityIntegerField createIntegerField(@NotNull String fieldId) {
        return new IndexedEntityIntegerFieldImpl(fieldId, Field.Store.YES);
    }

    public static IndexedEntityLongField createLongField(@NotNull String fieldId) {
        return new IndexedEntityLongFieldImpl(fieldId, Field.Store.YES);
    }

    public static IndexedEntityTextField createTextField(@NotNull String fieldId, @NotNull Field.Store stored) {
        return new IndexedEntityTextFieldImpl(fieldId, stored);
    }

    public static <T extends Enum<T>> IndexedEntityEnumField<T> createEnumField(@NotNull Class<T> enumType, @NotNull String fieldId) {
        return new IndexedEntityEnumFieldImpl<T>(enumType, fieldId, Field.Store.YES);
    }
}

