/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.AbstractIndexedEntityField;
import com.atlassian.bamboo.index.fields.IndexedEntityIdField;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import com.google.common.base.MoreObjects;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.NumericRangeQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedEntityIdFieldImpl
extends AbstractIndexedEntityField<Long>
implements IndexedEntityIdField {
    private static final Logger log = Logger.getLogger(IndexedEntityIdFieldImpl.class);

    protected IndexedEntityIdFieldImpl(@NotNull String fieldId, @NotNull Field.Store stored) {
        super(fieldId, stored);
    }

    @Override
    @NotNull
    public Long getValue(@NotNull Document document) {
        return (Long)MoreObjects.firstNonNull(super.getValue(document), (Object)-1L);
    }

    @Override
    @Nullable
    protected Long valueFromField(@NotNull IndexableField field) {
        Number value = field.numericValue();
        if (value != null) {
            return value.longValue();
        }
        log.info((Object)String.format("Field %s doesn't contain proper numeric value", field.name()));
        return null;
    }

    @Override
    @NotNull
    protected IndexableField valueToField(@NotNull Long value) {
        return new LongField(this.fieldId, value.longValue(), this.stored);
    }

    @Override
    @NotNull
    public Term createTerm(@NotNull Long value) {
        return LuceneQueryBuilder.term(this.fieldId, value);
    }

    @NotNull
    public NumericRangeQuery<Long> createQuery(@NotNull Long value) {
        return LuceneQueryBuilder.numericQuery(this.fieldId, value);
    }
}

