/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.AbstractIndexedEntityField;
import com.atlassian.bamboo.index.fields.IndexedEntityIntegerField;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.NumericRangeQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedEntityIntegerFieldImpl
extends AbstractIndexedEntityField<Integer>
implements IndexedEntityIntegerField {
    private static final Logger log = Logger.getLogger(IndexedEntityIntegerFieldImpl.class);

    protected IndexedEntityIntegerFieldImpl(@NotNull String fieldId, @NotNull Field.Store stored) {
        super(fieldId, stored);
    }

    @Override
    @Nullable
    protected Integer valueFromField(@NotNull IndexableField field) {
        Number value = field.numericValue();
        if (value != null) {
            return value.intValue();
        }
        log.info((Object)String.format("Field %s doesn't contain proper numeric value", field.name()));
        return null;
    }

    @Override
    @NotNull
    protected IndexableField valueToField(@NotNull Integer value) {
        return new IntField(this.fieldId, value.intValue(), this.stored);
    }

    @Override
    @NotNull
    public Term createTerm(@NotNull Integer value) {
        return LuceneQueryBuilder.term(this.fieldId, value.intValue());
    }

    @NotNull
    public NumericRangeQuery<Integer> createQuery(@NotNull Integer value) {
        return LuceneQueryBuilder.numericQuery(this.fieldId, value);
    }

    public int getValue(@NotNull Document document, int defaultValue) {
        Integer value = (Integer)this.getValue(document);
        return value != null ? value : defaultValue;
    }
}

