/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.AbstractIndexedEntityField;
import com.atlassian.bamboo.index.fields.IndexedEntityLongField;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.NumericRangeQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedEntityLongFieldImpl
extends AbstractIndexedEntityField<Long>
implements IndexedEntityLongField {
    private static final Logger log = Logger.getLogger(IndexedEntityLongFieldImpl.class);

    protected IndexedEntityLongFieldImpl(@NotNull String fieldId, @NotNull Field.Store stored) {
        super(fieldId, stored);
    }

    @Override
    @Nullable
    protected Long valueFromField(@NotNull IndexableField field) {
        Number value = field.numericValue();
        if (value != null) {
            return value.longValue();
        }
        log.info((Object)String.format("Field %s doesn't contain proper numeric value", field.name()));
        return null;
    }

    @Override
    @NotNull
    protected IndexableField valueToField(@NotNull Long value) {
        return new LongField(this.fieldId, value.longValue(), this.stored);
    }

    public long getValue(@NotNull Document document, long defaultValue) {
        Long value = (Long)this.getValue(document);
        return value != null ? value : defaultValue;
    }

    @Override
    @NotNull
    public Term createTerm(@NotNull Long value) {
        return LuceneQueryBuilder.term(this.fieldId, value);
    }

    @NotNull
    public NumericRangeQuery<Long> createQuery(@NotNull Long value) {
        return LuceneQueryBuilder.numericQuery(this.fieldId, value);
    }
}

