/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.fields;

import com.atlassian.bamboo.index.fields.AbstractIndexedEntityField;
import com.atlassian.bamboo.index.fields.IndexedEntityPlanResultKeyField;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedEntityPlanResultKeyFieldImpl
extends AbstractIndexedEntityField<PlanResultKey>
implements IndexedEntityPlanResultKeyField {
    private static final Logger log = Logger.getLogger(IndexedEntityPlanResultKeyFieldImpl.class);

    protected IndexedEntityPlanResultKeyFieldImpl(@NotNull String fieldId, @NotNull Field.Store stored) {
        super(fieldId, stored);
    }

    @Override
    @Nullable
    protected PlanResultKey valueFromField(@NotNull IndexableField field) {
        String value = field.stringValue();
        try {
            return PlanKeys.getPlanResultKey((String)value);
        }
        catch (Exception e) {
            log.warn((Object)String.format("Incorrect PlanResultKey '%s' in field '%s', null will be returned", value, this.fieldId), (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    protected IndexableField valueToField(@NotNull PlanResultKey value) {
        return new StringField(this.fieldId, value.getKey(), this.stored);
    }
}

