/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.quicksearch;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocument;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocumentImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.util.NumberUtils;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickSearchDocumentFactory {
    public static final String FIELD_PLAN_NAME = "planName";
    public static final String FIELD_PROJECT_NAME = "projectName";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_BRANCH_NAME = "branchName";
    public static final String FIELD_MASTER_ID = "masterId";

    public static QuickSearchDocument forProject(Project project) {
        return new Builder().id(project.getId()).key(project.getKey()).type(Type.PROJECT).property(FIELD_PROJECT_NAME, project.getName()).property(FIELD_DESCRIPTION, project.getDescription()).searchToken(project.getName()).build();
    }

    public static QuickSearchDocument forChain(ImmutableChain chain) {
        return new Builder().id(chain.getId()).key(chain.getPlanKey().getKey()).type(Type.CHAIN).property(FIELD_PROJECT_NAME, chain.getProject().getName()).property(FIELD_PLAN_NAME, chain.getBuildName()).property(FIELD_DESCRIPTION, chain.getDescription()).searchToken(chain.getProject().getName()).searchToken(chain.getBuildName()).build();
    }

    public static QuickSearchDocument forBranch(ImmutableChainBranch branch) {
        return new Builder().id(branch.getId()).key(branch.getPlanKey().getKey()).type(Type.BRANCH).property(FIELD_PROJECT_NAME, branch.getProject().getName()).property(FIELD_PLAN_NAME, ((ImmutableChain)Preconditions.checkNotNull((Object)branch.getMaster())).getBuildName()).property(FIELD_BRANCH_NAME, branch.getBuildName()).property(FIELD_MASTER_ID, Long.toString(branch.getMasterId())).searchToken(branch.getBuildName()).build();
    }

    public static QuickSearchDocument forDeploymentProject(DeploymentProject deploymentProject) {
        return new Builder().id(deploymentProject.getId()).type(Type.DEPLOYMENTPROJECT).property(FIELD_PROJECT_NAME, deploymentProject.getName()).property(FIELD_DESCRIPTION, deploymentProject.getDescription()).searchToken(deploymentProject.getName()).build();
    }

    @Nullable
    public static ObjectIdentity getObjectIdentityForDocument(@NotNull Document document) {
        Type type;
        long id = QuickSearchDocumentImpl.FIELD_ID.getValue(document);
        if (id > 0L && (type = (Type)((Object)QuickSearchDocumentImpl.FIELD_TYPE.getValue(document))) != null) {
            switch (type) {
                case PROJECT: {
                    return new HibernateObjectIdentityImpl(DefaultProject.class, (Serializable)Long.valueOf(id));
                }
                case CHAIN: {
                    return new HibernateObjectIdentityImpl(DefaultChain.class, (Serializable)Long.valueOf(id));
                }
                case BRANCH: {
                    long masterId = NumberUtils.stringToLong((String)document.get(FIELD_MASTER_ID));
                    if (masterId <= 0L) break;
                    return new HibernateObjectIdentityImpl(DefaultChain.class, (Serializable)Long.valueOf(masterId));
                }
                case DEPLOYMENTPROJECT: {
                    return new HibernateObjectIdentityImpl(InternalDeploymentProject.class, (Serializable)Long.valueOf(id));
                }
            }
        }
        return null;
    }

    static class Builder {
        private long id;
        private Type type;
        private String key;
        private final Map<String, String> entity = new HashMap<String, String>();
        private final List<String> searchTokens = new ArrayList<String>();

        Builder() {
        }

        Builder id(long id) {
            this.id = id;
            return this;
        }

        Builder type(Type type) {
            this.type = type;
            return this;
        }

        Builder property(String key, String value) {
            this.entity.put(key, value);
            return this;
        }

        Builder searchToken(String token) {
            this.searchTokens.add(token);
            return this;
        }

        Builder key(String key) {
            this.key = key;
            return this;
        }

        QuickSearchDocument build() {
            return new QuickSearchDocumentImpl(this.id, this.type, this.key, this.entity, this.searchTokens);
        }
    }

    public static enum Type {
        PROJECT,
        CHAIN,
        BRANCH,
        DEPLOYMENTPROJECT;

    }
}

