/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.quicksearch;

import com.atlassian.bamboo.index.fields.IndexedEntityEnumField;
import com.atlassian.bamboo.index.fields.IndexedEntityFieldFactory;
import com.atlassian.bamboo.index.fields.IndexedEntityIdField;
import com.atlassian.bamboo.index.fields.IndexedEntityTextField;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocument;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocumentFactory;
import com.atlassian.bamboo.web.Jsonate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickSearchDocumentImpl
implements QuickSearchDocument {
    public static final IndexedEntityIdField FIELD_ID = IndexedEntityFieldFactory.createIdField("searchItemId");
    public static final IndexedEntityTextField FIELD_KEY = IndexedEntityFieldFactory.createTextField("key");
    public static final IndexedEntityEnumField<QuickSearchDocumentFactory.Type> FIELD_TYPE = IndexedEntityFieldFactory.createEnumField(QuickSearchDocumentFactory.Type.class, "searchItemType");
    private final long id;
    private final QuickSearchDocumentFactory.Type type;
    private final String key;
    private final Map<String, String> entity;
    private final List<String> searchTokens;

    public QuickSearchDocumentImpl(long id, @NotNull QuickSearchDocumentFactory.Type type, @Nullable String key, @NotNull Map<String, String> entity, @NotNull List<String> searchTokens) {
        this.id = id;
        this.type = type;
        this.entity = entity;
        this.searchTokens = searchTokens;
        this.key = key;
    }

    public QuickSearchDocumentImpl(@NotNull Document doc) {
        this.id = FIELD_ID.getValue(doc);
        this.type = (QuickSearchDocumentFactory.Type)((Object)FIELD_TYPE.getValue(doc));
        this.key = (String)FIELD_KEY.getValue(doc);
        this.searchTokens = new ArrayList<String>();
        this.entity = new HashMap<String, String>();
        for (Object o : doc.getFields()) {
            Field field = (Field)o;
            if (FIELD_TYPE.getFieldId().equals(field.name()) || FIELD_ID.getFieldId().equals(field.name())) continue;
            this.entity.put(field.name(), field.stringValue());
        }
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = new Document();
        FIELD_ID.addToDocument(document, (Object)this.id);
        FIELD_KEY.addToDocument(document, (Object)this.key);
        FIELD_TYPE.addToDocument(document, (Object)this.type);
        for (Map.Entry<String, String> property : this.entity.entrySet()) {
            String value = property.getValue();
            if (value == null) continue;
            document.add((IndexableField)new StoredField(property.getKey(), value));
        }
        document.add((IndexableField)new TextField("searchField", StringUtils.join(this.searchTokens, (String)" "), Field.Store.NO));
        return document;
    }

    @Override
    @Jsonate
    public long getId() {
        return this.id;
    }

    @Override
    @Jsonate
    public QuickSearchDocumentFactory.Type getType() {
        return this.type;
    }

    @Override
    @Jsonate
    public Map<String, String> getEntity() {
        return this.entity;
    }
}

