/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.quicksearch;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.events.ChainMovedEvent;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.events.DeploymentProjectConfigUpdatedEvent;
import com.atlassian.bamboo.deployments.projects.events.DeploymentProjectCreatedEvent;
import com.atlassian.bamboo.deployments.projects.events.DeploymentProjectDeletedEvent;
import com.atlassian.bamboo.deployments.projects.events.DeploymentProjectEvent;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.event.ChainDeletedEvent;
import com.atlassian.bamboo.event.MultipleChainsDeletedEvent;
import com.atlassian.bamboo.event.PlanEvent;
import com.atlassian.bamboo.event.ProjectCreatedEvent;
import com.atlassian.bamboo.event.ProjectDeletedEvent;
import com.atlassian.bamboo.event.ProjectUpdatedEvent;
import com.atlassian.bamboo.index.AbstractIndexer;
import com.atlassian.bamboo.index.IndexerBandanaContext;
import com.atlassian.bamboo.index.IndexerContext;
import com.atlassian.bamboo.index.IndexerService;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocument;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocumentFactory;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocumentImpl;
import com.atlassian.bamboo.index.quicksearch.QuickSearchIndexer;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class QuickSearchIndexerImpl
extends AbstractIndexer
implements QuickSearchIndexer {
    private static final Logger log = Logger.getLogger(QuickSearchIndexerImpl.class);
    private final CachedPlanManager cachedPlanManager;
    private final DeploymentProjectService deploymentProjectService;
    private final EventPublisher eventPublisher;
    private final ProjectManager projectManager;
    private final PlanManager planManager;

    public QuickSearchIndexerImpl(ILuceneConnection luceneConnection, IndexerService indexerService, CachedPlanManager cachedPlanManager, DeploymentProjectService deploymentProjectService, HibernateConfig hibernateConfig, EventPublisher eventPublisher, BandanaManager bandanaManager, ProjectManager projectManager, PlanManager planManager) {
        super(luceneConnection, bandanaManager, BambooHibernateUtils.getMaxConnectionPoolSize(hibernateConfig), indexerService);
        this.cachedPlanManager = cachedPlanManager;
        this.deploymentProjectService = deploymentProjectService;
        this.eventPublisher = eventPublisher;
        this.projectManager = projectManager;
        this.planManager = planManager;
    }

    @PostConstruct
    private void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void indexAll(@NotNull Executor executor) throws Exception {
        log.info((Object)"Starting full re-index for search");
        Set projects = this.projectManager.getAllProjects();
        List plans = this.cachedPlanManager.getPlans();
        List deploymentProjects = this.deploymentProjectService.getAllDeploymentProjects();
        IndexerContext indexerContext = this.lockIndexerQueue();
        int tasksToProcess = projects.size() + plans.size() + deploymentProjects.size();
        int itemsToIndex = projects.size() + this.planManager.getPlanCount(Chain.class) + deploymentProjects.size();
        if (tasksToProcess == 0) {
            log.info((Object)"There are no entities to index");
            this.flushAndUnlockIndexerQueue(indexerContext);
            return;
        }
        log.info((Object)String.format("Scheduling indexing of %d entities", tasksToProcess));
        AbstractIndexer.FlushAndUnlockIndexerQueueCallback flushAndUnlockIndexerQueueCallback = new AbstractIndexer.FlushAndUnlockIndexerQueueCallback((AbstractIndexer)this, tasksToProcess, indexerContext);
        AbstractIndexer.UpdateApproximateIndexingTimePerResultCallback updateApproximateIndexingTimePerResultCallback = new AbstractIndexer.UpdateApproximateIndexingTimePerResultCallback((AbstractIndexer)this, tasksToProcess, itemsToIndex);
        for (Project project : projects) {
            ListenableFutureTask<Long> indexProjectTask = this.createIndexProjectTask(indexerContext, project);
            Futures.addCallback(indexProjectTask, (FutureCallback)flushAndUnlockIndexerQueueCallback);
            Futures.addCallback(indexProjectTask, (FutureCallback)updateApproximateIndexingTimePerResultCallback);
            executor.execute((Runnable)indexProjectTask);
        }
        for (ImmutableTopLevelPlan plan : plans) {
            ListenableFutureTask<Long> indexPlanAndBranchesTask = this.createIndexPlanAndBranchesTask(indexerContext, (ImmutableChain)plan);
            Futures.addCallback(indexPlanAndBranchesTask, (FutureCallback)flushAndUnlockIndexerQueueCallback);
            Futures.addCallback(indexPlanAndBranchesTask, (FutureCallback)updateApproximateIndexingTimePerResultCallback);
            executor.execute((Runnable)indexPlanAndBranchesTask);
        }
        for (DeploymentProject deploymentProject : deploymentProjects) {
            ListenableFutureTask<Long> indexDeploymentTask = this.createIndexDeploymentTask(indexerContext, deploymentProject);
            Futures.addCallback(indexDeploymentTask, (FutureCallback)flushAndUnlockIndexerQueueCallback);
            Futures.addCallback(indexDeploymentTask, (FutureCallback)updateApproximateIndexingTimePerResultCallback);
            executor.execute((Runnable)indexDeploymentTask);
        }
    }

    @EventListener
    public void onProjectCreated(@NotNull ProjectCreatedEvent event) {
        Project projectByKey = this.projectManager.getProjectByKey(event.getProjectKey());
        if (projectByKey != null) {
            this.indexProject(projectByKey);
        }
    }

    @EventListener
    public void onProjectUpdated(@NotNull ProjectUpdatedEvent event) {
        Project projectByKey = this.projectManager.getProjectByKey(event.getProjectKey());
        if (projectByKey != null) {
            this.indexProject(projectByKey);
        }
    }

    @EventListener
    public void onProjectDeleted(@NotNull ProjectDeletedEvent event) {
        this.deindexItem(event.getProjectId());
    }

    @EventListener
    public void onChainCreated(@NotNull ChainCreatedEvent event) {
        ImmutablePlan planByKey = this.cachedPlanManager.getPlanByKey(event.getPlanKey());
        if (planByKey instanceof ImmutableTopLevelPlan) {
            this.indexChain((ImmutableTopLevelPlan)planByKey);
        } else if (planByKey instanceof ImmutableChainBranch) {
            this.indexBranch((ImmutableChainBranch)planByKey);
        } else if (planByKey == null) {
            log.warn((Object)("Chain Created Event thrown for non existent plan: " + event));
        } else {
            log.warn((Object)("Chain Created event thrown for non-chain object: " + event));
        }
    }

    @EventListener
    public void onChainDeletedEvent(@NotNull ChainDeletedEvent event) {
        this.deindexItem(event.getIdOfDeletedItem());
    }

    @EventListener
    public void onChainMoved(@NotNull ChainMovedEvent event) {
        this.reindexChain(event);
    }

    @EventListener
    public void onMultipleChainDeletedEvent(@NotNull MultipleChainsDeletedEvent event) {
        for (PlanKey planKey : event.getPlanKeys()) {
            this.indexerService.deleteDocuments(this.getDefaultIndexerContext(), QuickSearchDocumentImpl.FIELD_KEY.createTerm((Object)planKey.getKey()));
        }
    }

    @EventListener
    public void onBuildConfigUpdatedEvent(@NotNull BuildConfigurationUpdatedEvent event) {
        this.reindexChain(event);
    }

    private void reindexChain(PlanEvent event) {
        ImmutablePlan planByKey = this.cachedPlanManager.getPlanByKey(event.getPlanKey());
        if (planByKey instanceof ImmutableTopLevelPlan) {
            this.indexChain((ImmutableTopLevelPlan)planByKey);
        } else if (planByKey instanceof ImmutableChainBranch) {
            this.indexBranch((ImmutableChainBranch)planByKey);
        } else if (planByKey == null) {
            log.warn((Object)("reindex event thrown for non existent plan: " + event));
        }
    }

    @EventListener
    public void indexDeploymentProject(@NotNull DeploymentProjectCreatedEvent event) {
        this.indexDeploymentProjectFromEvent((DeploymentProjectEvent)event);
    }

    @EventListener
    public void indexDeploymentProject(@NotNull DeploymentProjectConfigUpdatedEvent event) {
        this.indexDeploymentProjectFromEvent((DeploymentProjectEvent)event);
    }

    @EventListener
    public void deleteDeploymentProject(@NotNull DeploymentProjectDeletedEvent event) {
        this.deindexItem(event.getDeploymentProjectId());
    }

    public long getEstimatedReindexTime() {
        long approximateIndexingTime = this.getApproximateIndexingTimePerResult() * (long)(this.planManager.getPlanCount(Chain.class) + this.deploymentProjectService.getDeploymentProjectCount()) / (long)this.getConcurrentIndexers();
        return TimeUnit.MILLISECONDS.toSeconds(approximateIndexingTime);
    }

    protected BambooBandanaContext getIndexerBandanaContext() {
        return IndexerBandanaContext.forIndexer(this);
    }

    private void indexDeploymentProjectFromEvent(@NotNull DeploymentProjectEvent event) {
        long deploymentProjectId = event.getDeploymentProjectId();
        DeploymentProject project = this.deploymentProjectService.getDeploymentProject(deploymentProjectId);
        if (project != null) {
            this.indexDeploymentProject(project);
        } else {
            log.warn((Object)("Asked to index project which does not exist. id: " + deploymentProjectId));
        }
    }

    private void indexProject(@NotNull Project project) {
        QuickSearchDocument chainBranchQuickSearchDocument = QuickSearchDocumentFactory.forProject(project);
        this.indexerService.updateDocument(this.getDefaultIndexerContext(), QuickSearchDocumentImpl.FIELD_ID.createTerm((Object)project.getId()), chainBranchQuickSearchDocument.getDocument());
    }

    private void indexChain(@NotNull ImmutableTopLevelPlan chain) {
        QuickSearchDocument chainBranchQuickSearchDocument = QuickSearchDocumentFactory.forChain((ImmutableChain)chain);
        this.indexerService.updateDocument(this.getDefaultIndexerContext(), QuickSearchDocumentImpl.FIELD_ID.createTerm((Object)chain.getId()), chainBranchQuickSearchDocument.getDocument());
    }

    private void indexBranch(@NotNull ImmutableChainBranch branch) {
        QuickSearchDocument chainBranchQuickSearchDocument = QuickSearchDocumentFactory.forBranch(branch);
        this.indexerService.updateDocument(this.getDefaultIndexerContext(), QuickSearchDocumentImpl.FIELD_ID.createTerm((Object)branch.getId()), chainBranchQuickSearchDocument.getDocument());
    }

    private void indexDeploymentProject(@NotNull DeploymentProject deploymentProject) {
        QuickSearchDocument projectQuickSearchDocument = QuickSearchDocumentFactory.forDeploymentProject(deploymentProject);
        this.indexerService.updateDocument(this.getDefaultIndexerContext(), QuickSearchDocumentImpl.FIELD_ID.createTerm((Object)deploymentProject.getId()), projectQuickSearchDocument.getDocument());
    }

    private void deindexItem(long id) {
        this.indexerService.deleteDocuments(this.getDefaultIndexerContext(), QuickSearchDocumentImpl.FIELD_ID.createTerm((Object)id));
    }

    private ListenableFutureTask<Long> createIndexProjectTask(@NotNull IndexerContext indexerContext, final @NotNull Project project) {
        return ListenableFutureTask.create((Callable)new AbstractIndexer.IndexAllCallable(indexerContext){

            public void run() {
                QuickSearchDocument projectQuickSearchDocument = QuickSearchDocumentFactory.forProject(project);
                QuickSearchIndexerImpl.this.indexerService.addDocument(this.indexerContext, projectQuickSearchDocument.getDocument());
            }
        });
    }

    private ListenableFutureTask<Long> createIndexPlanAndBranchesTask(@NotNull IndexerContext indexerContext, final @NotNull ImmutableChain plan) {
        return ListenableFutureTask.create((Callable)new AbstractIndexer.IndexAllCallable(indexerContext){

            public void run() {
                QuickSearchDocument chainQuickSearchDocument = QuickSearchDocumentFactory.forChain(plan);
                QuickSearchIndexerImpl.this.indexerService.addDocument(this.indexerContext, chainQuickSearchDocument.getDocument());
                List branches = QuickSearchIndexerImpl.this.cachedPlanManager.getBranchesForChain((PlanIdentifier)plan);
                for (ImmutableChainBranch branch : branches) {
                    QuickSearchDocument chainBranchQuickSearchDocument = QuickSearchDocumentFactory.forBranch(branch);
                    QuickSearchIndexerImpl.this.indexerService.addDocument(this.indexerContext, chainBranchQuickSearchDocument.getDocument());
                }
            }
        });
    }

    private ListenableFutureTask<Long> createIndexDeploymentTask(@NotNull IndexerContext indexerContext, final @NotNull DeploymentProject project) {
        return ListenableFutureTask.create((Callable)new AbstractIndexer.IndexAllCallable(indexerContext){

            public void run() {
                QuickSearchDocument projectQuickSearchDocument = QuickSearchDocumentFactory.forDeploymentProject(project);
                QuickSearchIndexerImpl.this.indexerService.addDocument(this.indexerContext, projectQuickSearchDocument.getDocument());
            }
        });
    }
}

