/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.quicksearch;

import com.atlassian.bamboo.index.IndexerService;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocument;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocumentFactory;
import com.atlassian.bamboo.index.quicksearch.QuickSearchDocumentImpl;
import com.atlassian.bamboo.index.quicksearch.QuickSearchSearcher;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacadeFactory;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bonnie.ILuceneConnection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.annotations.NotNull;

public class QuickSearchSearcherImpl
implements QuickSearchSearcher {
    private static final int RESULT_COUNT = 12;
    private static final int PAGE_SIZE = 1000;
    private final ILuceneConnection luceneConnection;
    @Inject
    private BambooCachingPermissionManagerFacadeFactory cachingPermissionManagerFacadeFactory;
    private final IndexerService indexerService;

    public QuickSearchSearcherImpl(ILuceneConnection luceneConnection, IndexerService indexerService) {
        this.luceneConnection = luceneConnection;
        this.indexerService = indexerService;
    }

    @Override
    @NotNull
    public List<QuickSearchDocument> findItemsMatching(@NotNull String searchTerm) {
        ArrayList searchTerms = Lists.newArrayList((Object[])searchTerm.split("[\\s-]"));
        BooleanQuery booleanQuery = new BooleanQuery();
        for (String item : searchTerms) {
            WildcardQuery termQuery = new WildcardQuery(new Term("searchField", item.toLowerCase() + "*"));
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
        }
        BambooCachingPermissionManagerFacade bambooCachingPermissionManagerFacade = this.cachingPermissionManagerFacadeFactory.create();
        List results = this.indexerService.getMatchingDocuments(this.indexerService.createNewIndexerContext(this.luceneConnection), searcher -> this.getQuickSearchDocuments(searcher, bambooCachingPermissionManagerFacade, booleanQuery, 12, 1000));
        TreeMap<QuickSearchDocumentFactory.Type, List> mappedResults = new TreeMap<QuickSearchDocumentFactory.Type, List>();
        for (QuickSearchDocument document : results) {
            List quickSearchDocuments = mappedResults.computeIfAbsent(document.getType(), k -> new ArrayList());
            quickSearchDocuments.add(document);
        }
        ArrayList<QuickSearchDocument> sortedResults = new ArrayList<QuickSearchDocument>();
        for (List subList : mappedResults.values()) {
            sortedResults.addAll(subList);
        }
        return sortedResults;
    }

    @VisibleForTesting
    protected List<QuickSearchDocument> getQuickSearchDocuments(IndexSearcher searcher, BambooCachingPermissionManagerFacade cachingPermissionManagerFacade, BooleanQuery booleanQuery, int resultCount, int pagesize) throws IOException {
        int requestAmount;
        TopDocs topDocs;
        ArrayList<QuickSearchDocument> results = new ArrayList<QuickSearchDocument>();
        int startIndex = 0;
        while (results.size() < resultCount && (topDocs = searcher.search((Query)booleanQuery, requestAmount = startIndex + pagesize)) != null) {
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            for (int i = startIndex; i < scoreDocs.length; ++i) {
                ScoreDoc doc = scoreDocs[i];
                Document document = searcher.doc(doc.doc);
                if (!this.hasPermission(cachingPermissionManagerFacade, document)) continue;
                results.add(new QuickSearchDocumentImpl(document));
                if (results.size() >= resultCount) break;
            }
            if (scoreDocs.length < requestAmount) break;
            startIndex = requestAmount;
        }
        return results;
    }

    @VisibleForTesting
    protected boolean hasPermission(BambooCachingPermissionManagerFacade cachingPermissionManagerFacade, Document document) {
        ObjectIdentity objectIdentity = QuickSearchDocumentFactory.getObjectIdentityForDocument(document);
        return objectIdentity != null && (PlanIdentifier.class.isAssignableFrom(objectIdentity.getJavaType()) ? cachingPermissionManagerFacade.hasPlanPermission(BambooPermission.READ, ((Long)objectIdentity.getIdentifier()).longValue()) : cachingPermissionManagerFacade.hasPermission((Permission)BambooPermission.READ, (Object)objectIdentity));
    }
}

